%{ open Ast %}

%token PLUS MINUS TIMES DIVIDE EQUAL NOTEQUAL AND SEMICOLON LT GT LTEQUAL GTEQUAL NOT VARIABLE ASSIGN OR IF ELSE RETURN WHILE LET
%token INT FLOAT BOOL STRING TABLE COLUMN INNER LEFT RIGHT CREATE DELETE INSERT
%token JOIN SELECT EXTEND DISTINCT WHERE
%token LBRACKET RBRACKET LPARENTHESIS RPARENTHESIS COMMA
%token IMPORT AS PRINT

%token <string> VARIABLE
%token <int> INTLIT
%token <float> FLOATLIT
%token <bool> BOOLLIT
%token <string> STRINGLIT
%token <string> TABLELIT 
%token <string> COLUMNLIT 
%token EOF

%left SEMICOLON
%left RETURN
%left VARIABLE
%right ASSIGN 
%left IF WHILE
%left COLUMNLIT INTLIT
%left COMMA
%left IMPORT AS
%left INSERT JOIN SELECT EXTEND DISTINCT WHERE CREATE DELETE
%left OR 
%left AND
%right NOT
%left EQUAL NOTEQUAL LT GT LTEQUAL GTEQUAL
%left PLUS MINUS
%left TIMES DIVIDE
%left LPARENTHESIS RPARENTHESIS

%start stmt
%type <Ast.stmt> stmt


%%
stmt:
| stmt SEMICOLON { Semi1($1) }
| stmt SEMICOLON stmt { Semi($1, $3) }
| IF LPARENTHESIS expr RPARENTHESIS blockExpr ELSE blockExpr {ConditionWithElse($3,$5,$7)}
| IF LPARENTHESIS expr RPARENTHESIS blockExpr {Condition($3,$5)}
| WHILE LPARENTHESIS expr RPARENTHESIS blockExpr {While($3, $5)}
| expr { Expr($1)}
| LET primitive VARIABLE LPARENTHESIS columnDecls RPARENTHESIS ASSIGN blockExpr {DefineFunction($2, $3, $5, $8)}
| PRINT expr { Print($2) }

blockExpr:
| LBRACKET stmt RBRACKET {$2}


tableExpr:
| TABLELIT  { TableLit($1) }
| tableExpr JOIN LPARENTHESIS INNER tableExpr COMMA columnNames COMMA columnNames RPARENTHESIS { Join( "Inner",$1,$5, $7, $9) }
| tableExpr JOIN LPARENTHESIS LEFT tableExpr COMMA columnNames COMMA columnNames RPARENTHESIS { Join( "Left", $1, $5, $7, $9) }
| tableExpr JOIN LPARENTHESIS RIGHT tableExpr COMMA columnNames COMMA columnNames RPARENTHESIS { Join( "Right", $1, $5, $7, $9) }
| tableExpr DISTINCT LPARENTHESIS columnNames RPARENTHESIS { Distinct($1, $4) }
| tableExpr SELECT LPARENTHESIS columnNames RPARENTHESIS { Select($1, $4) }
| tableExpr WHERE LPARENTHESIS columnExpressions RPARENTHESIS { Where($1, $4) }
| tableExpr DELETE LPARENTHESIS columnExpressions RPARENTHESIS { Delete($1, $4) }
| tableExpr INSERT LPARENTHESIS exprs RPARENTHESIS { Insert($1, $4) }
| IMPORT STRINGLIT LBRACKET primitives RBRACKET { ReadFile($2, $4) }
| TABLE LBRACKET columnDecls RBRACKET { Create($3) }

columnNames:
| COLUMNLIT {[$1]}
| COLUMNLIT COMMA columnNames {$1 :: $3}

columnExpressions:
| COLUMNLIT EQUAL expr { ($1,Equ,$3) }
| COLUMNLIT NOTEQUAL expr { ($1,Neq,$3) }
| COLUMNLIT GTEQUAL expr { ($1,Gteq,$3) }
| COLUMNLIT LTEQUAL expr { ($1,Lteq,$3) }
| COLUMNLIT LT expr { ($1,Lt,$3) }
| COLUMNLIT GT expr { ($1,Gt,$3) }

columnDecls:
| primitive VARIABLE {[($1,$2)]}
| columnDecls COMMA primitive VARIABLE { ($3,$4) :: $1} 


exprs:
| expr {[$1]}
| exprs COMMA expr {$3::$1}

expr:
| tableExpr { TableExpr($1) }
| expr PLUS   expr { Binop($1, Add, $3) }
| expr MINUS  expr { Binop($1, Sub, $3) }
| expr TIMES  expr { Binop($1, Mul, $3) }
| expr DIVIDE expr { Binop($1, Div, $3) }
| expr EQUAL expr { Binop($1, Equ, $3) }
| expr NOTEQUAL expr { Binop($1, Neq, $3)}
| expr AND expr { Binop($1, And, $3) }
| expr OR expr { Binop($1, Or, $3) }
| expr LT expr { Binop($1, Lt, $3) }
| expr GT expr { Binop($1, Gt, $3) }
| expr GTEQUAL expr { Binop($1, Gteq, $3) }
| expr LTEQUAL expr { Binop($1, Lteq, $3) }
| NOT expr { Not($2) }
| VARIABLE { Val($1) }
| primitive VARIABLE ASSIGN expr { Assign($1, $2, $4) }
| VARIABLE ASSIGN expr { Reassign($1, $3) }
| TABLELIT ASSIGN expr { Reassign($1, $3) }
| primitive TABLELIT ASSIGN expr { Assign($1, $2, $4) }
| LPARENTHESIS expr RPARENTHESIS { $2 }

| RETURN expr SEMICOLON { Return($2) }
| cell { Cell($1) }

cell:
  INTLIT { IntLit($1) }
| FLOATLIT { FloatLit($1) }
| BOOLLIT { BoolLit($1) }
| STRINGLIT { StrLit($1) }


primitives:
| primitive {[$1]}
| primitives COMMA primitive { $3 :: $1} 

primitivesDecl:
| primitive {[($1,"_")]}
| primitivesDecl COMMA primitive { ($3,"_") :: $1} 

primitive:
  INT { Int }
| FLOAT { Float }
| BOOL { Bool }
| STRING { String }
| TABLE LBRACKET primitivesDecl RBRACKET { Table($3) }
| COLUMN {Column}
