#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// adjust BUFFER_SIZE to suit longest line
#define BUFFER_SIZE 1024 * 1024
#define INITIAL_TABLE_SIZE 32
#define RET_OK 0
#define RET_FAIL 1
#define FALSE 0
#define TRUE 1

struct Table
{
    void** ptr;
    int size;
};

char delim = ',';
// table manipulation
struct Table create_table(int size);
struct Table insert_table(struct Table structPointer, char** values, char** columnTypes, int numberOfFields);
struct Table import_table(char* filename, int numberOfFields, char** columnTypes);
struct Table select_table(struct Table p, int offsetArr[], char** typeArr, int size_offsetArr);
struct Table distinct_table(struct Table structPointer, int offsetArr[], char** typeArr, int size_offsetArr);
struct Table where_table(struct Table p, int offset, char* op, char* val, char* type_of_val);
struct Table delete_table(struct Table p, int offset, char* op, char* val, char* type_of_val);
void print_table(struct Table structPointer, char** columnTypes, int numberOfFields);

// helper functions
int getSize(char* type);
int loadFile(FILE *pFile, void** tableArr, int numberOfFields, char** columnTypes);
int  loadValues(char *line, long lineno, char** pFields, int numberOfFields);

struct Table import_table(char* filename, int numberOfFields, char** columnTypes)
{
    FILE *fp;
    void** lst = (void**)malloc(INITIAL_TABLE_SIZE * sizeof(void*));

    fp = fopen(filename , "r");
    if(fp == NULL) {
        printf("File not found");
        struct Table returnStruct = {NULL, 0};

        return returnStruct;
    }
    int lines = loadFile(fp, lst, numberOfFields, columnTypes);
    fclose(fp);

    struct Table returnStruct = {lst, lines-1};

    return returnStruct;
}

struct Table create_table(int size)
{
    void** s = malloc(sizeof(void*) * INITIAL_TABLE_SIZE);
    for (void* *p = s; *p; ++p) {
        p = malloc(size);
    }

    struct Table returnStruct = {s, 0};

    return returnStruct;
}

void print_table(struct Table t, char** columnTypes, int numberOfFields)
{
    void** structPointer = t.ptr;
    int tableSize =t.size;

    for (void* *p = structPointer; *p && tableSize--; ++p) {
        void* tmp = *p;
        for (int i = 0; i< numberOfFields; i++) {
            char* type = *(columnTypes+i);
            if(strcmp(type, "int") == 0)
                printf("%d ", *(int*)(tmp));
            else if(strcmp(type, "float") == 0)
                printf("%.2f ", *(float*)(tmp));
            else if(strcmp(type, "string") == 0){
                printf("%s ", *(char**)(tmp));
            }else if(strcmp(type, "boolean") == 0){
                printf("%s ", *(int*)(tmp) == 1? "true" : "false");
            }
            tmp = tmp+ getSize(type);
        }
        printf("\n");
    }
}

// helper functions
int getSize(char* type){
    if(strcmp(type, "int")==0) return sizeof(int);
    if(strcmp(type, "boolean")==0) return sizeof(int);
    if(strcmp(type, "float")==0) return sizeof(float);
    if(strcmp(type, "string")==0) return sizeof(char*);
}

int loadFile(FILE *pFile, void** tableArr, int numberOfFields, char** columnTypes){
    char *pFields[numberOfFields];
    char sInputBuf [BUFFER_SIZE];
    int lineno = 0L;
    char* buffer = NULL;

    if(pFile == NULL)
        return RET_FAIL;

    while (!feof(pFile)) {
        // load line into static buffer
        if(fgets(sInputBuf, BUFFER_SIZE-1, pFile)==NULL)
            break;

        // skip first line (headers)
        if(++lineno==1)
            continue;

        // jump over empty lines
        if(strlen(sInputBuf)==0)
            continue;

        // set pFields array pointers to null-terminated string fields in sInputBuf
        if(loadValues(sInputBuf,lineno, pFields, numberOfFields)==RET_FAIL){
            return RET_FAIL;
        } else {
            int totalSize = 0;
            for (int i = 0; i<numberOfFields; i++) {
                totalSize = totalSize + getSize(*(columnTypes+i));
            }
            void* structPointer = malloc(totalSize);
            tableArr[lineno-2] = structPointer;

            for (int i = 0; i<numberOfFields; i++) {
                char* type = *(columnTypes+i);
                if(strcmp(type, "int") == 0)
                    *((int*)structPointer) = atoi(pFields[i]);
                else if(strcmp(type, "float") == 0)
                    *((float*)structPointer) = atof(pFields[i]);
                else if(strcmp(type, "boolean") == 0)
                    *((int*)structPointer) = atoi(pFields[i]);
                else if(strcmp(type, "string") == 0){
                    buffer = malloc(32);
                    strcpy(buffer, pFields[i]);
                    *((char**)structPointer) = buffer;
                }
                structPointer = structPointer + getSize(type);
            }
        }
    }
    return lineno;
}

int loadValues(char *line, long lineno, char** pFields, int numberOfFields){
    if(line == NULL)
        return RET_FAIL;

    // chop of last char of input if it is a CR or LF (e.g.Windows file loading in Unix env.)
    // can be removed if sure fgets has removed both CR and LF from end of line
    if(*(line + strlen(line)-1) == '\r' || *(line + strlen(line)-1) == '\n')
        *(line + strlen(line)-1) = '\0';
    if(*(line + strlen(line)-1) == '\r' || *(line + strlen(line)-1 )== '\n')
        *(line + strlen(line)-1) = '\0';

    char *cptr = line;
    int fld = 0;
    int inquote = FALSE;
    char ch;

    pFields[fld]=cptr;
    while((ch=*cptr) != '\0' && fld < numberOfFields){
        if(ch == '"') {
            if(! inquote)
                pFields[fld]=cptr+1;
            else {
                *cptr = '\0';               // zero out " and jump over it
            }
            inquote = ! inquote;
        } else if(ch == delim && ! inquote){
            *cptr = '\0';                   // end of field, null terminate it
            pFields[++fld]=cptr+1;
        }
        cptr++;
    }
    if(fld > numberOfFields-1){
        printf("Expected field count (%d) exceeded on line %ld\n", numberOfFields, lineno);
        return RET_FAIL;
    } else if (fld < numberOfFields-1){
        printf("Expected field count (%d) not reached on line %ld\n", numberOfFields, lineno);
        return RET_FAIL;
    }
    return RET_OK;
}

struct Table select_table(struct Table t, int offsetArr[], char** typeArr, int size_offsetArr)
{
    void** p = t.ptr;
    int size_p =t.size;

    void** return_table = malloc(sizeof(void*) * size_p);
    int size_each_row = 0;
    for (int i = 0; i<size_offsetArr; i++) {
        size_each_row = size_each_row + getSize(*(typeArr+i));
    }

    int index = 0;
    while(index<size_p){
        void* this_row = p[index];
        return_table[index] = malloc(size_each_row);
        void* temp = return_table[index];
        //create a new array with the type for the elements in typeArr
        for (int i = 0; i < size_offsetArr; i++) {
            char* col_type = typeArr[i];
            void* row1 = p[index];
            if (strcmp(col_type,"int") == 0){
                *(int*)(temp) = *(int*)(row1+offsetArr[i]);
                temp = temp+4;
            }
            else if (strcmp(col_type,"string") == 0){
                *(char**)(temp) = *(char**)(row1+offsetArr[i]);
                temp = temp+8;
            }
            else if (strcmp(col_type,"float") == 0){
                *(float*)(temp) = *(float*)(row1+offsetArr[i]);
                temp = temp+4;
            }
            else if (strcmp(col_type,"boolean") == 0){
                *(int*)(temp) = *(int*)(row1+offsetArr[i]);
                temp = temp+4;
            }
        }
        index++;
    }

    struct Table returnStruct = {return_table, index};

    return returnStruct;
}

struct Table distinct_table(struct Table t, int offsetArr[], char** typeArr, int size_offsetArr){

    struct Table new_struct = select_table(t, offsetArr, typeArr, size_offsetArr);
    void** new_p = new_struct.ptr;

    void** return_table = malloc(sizeof(void*) * new_struct.size);
    //print_table(new_p, typeArr, 2);

    //convert select table in to string
    int size_p = new_struct.size;
    char* str_list[size_p];
    int str_list_index = 0;
    int return_index = 0;

    for (void* *p = new_p; *p&& size_p; ++p ) {
        size_p--;
        char* tmp_str = "";
        char* element = malloc(1024);
        void* tmp = *p;
        for (int i = 0; i< size_offsetArr; i++) {
            char* type = *(typeArr+i);
            if(strcmp(type, "int") == 0){
                int x  = *(int*)(tmp);
                int length = snprintf( NULL, 0, "%d", x );
                char* str = malloc( length + 1 );
                snprintf( str, length + 1, "%d", x );
                strcat(element, str);
            }else if(strcmp(type, "float") == 0){
                float f = *(float*)(tmp);
                int length = snprintf( NULL, 0, "%f", f );
                char* str = malloc( length + 1 );
                snprintf( str, length + 1, "%f", f );
                strcat(element, str);
            }else if(strcmp(type, "string") == 0){
                strcat(element, *(char**)(tmp));
            }else if(strcmp(type, "boolean") == 0){
                int b  = *(int*)(tmp);
                int length = snprintf( NULL, 0, "%d", b );
                char* str = malloc( length + 1 );
                snprintf( str, length + 1, "%d", b );
                strcat(element, str);
            }
            tmp = tmp+ getSize(type);
            strcat(element, " ");
        }
        int flag = 0;
        for (int j = 0; j<return_index; j++){
            if(strcmp(str_list[j],element)==0){
                flag = 1;
                break;
            }
        }
        if(flag==0){
            str_list[return_index] = element;
            return_table[return_index] = *p;
            return_index +=1;
        }
    }

    struct Table returnStruct = {return_table, return_index};

    return returnStruct;

}

struct Table where_table(struct Table t, int offset, char* op, char* val, char* type_of_val){
    void** p = t.ptr;
    int size_p = t.size;
    void** return_table = malloc(sizeof(void*) * size_p);
    int rt_index = 0;

    for(int i = 0; i < size_p; i++){
        void* row = p[i];
        if(strcmp(type_of_val, "string") == 0){
            if(strcmp(op, "==") == 0){
                if(strcmp(*(char**)(row + offset), val) == 0){
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if(strcmp(op, "!=") == 0){
                if(strcmp(*(char**)(row + offset), val) != 0){
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }
        }else if(strcmp(type_of_val, "int") == 0){
            if(strcmp(op, "==") == 0){
                if(*(int*) (row + offset) == atoi(val)){
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if(strcmp(op, "<=") == 0) {
                if (*(int*) (row + offset) <= atoi(val)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if (strcmp(op, ">=") == 0) {
                if (*(int*) (row + offset) >= atoi(val)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if (strcmp(op, "!=") == 0) {
                if (*(int*) (row + offset) != atoi(val)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if (strcmp(op, ">") == 0) {
                if (*(int*) (row + offset) > atoi(val)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if(strcmp(op, "<") == 0) {
                if (*(int*) (row + offset) < atoi(val)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }
        }else if(strcmp(type_of_val, "float") == 0){
            if(strcmp(op, "==") == 0){
                if((roundf(*(float*) (row + offset))*10/10) == (roundf(atof(val))*10/10)){
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if(strcmp(op, "<=") == 0) {
                if ((roundf(*(float*) (row + offset))*10/10) <= (roundf(atof(val))*10/10)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if (strcmp(op, ">=") == 0) {
                if ((roundf(*(float*) (row + offset))*10/10)>= (roundf(atof(val))*10/10)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if (strcmp(op, "!=") == 0) {
                if ((roundf(*(float*) (row + offset))*10/10) != (roundf(atof(val))*10/10)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if (strcmp(op, ">") == 0) {
                if ((roundf(*(float*) (row + offset))*10/10) > (roundf(atof(val))*10/10)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if(strcmp(op, "<") == 0) {
                if ((roundf(*(float*) (row + offset))*10/10) < (roundf(atof(val))*10/10)) {
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }
        }else if(strcmp(type_of_val, "boolean") == 0){
            if(strcmp(op, "==") == 0){
                if(*(int*) (row + offset) == atoi(val)){
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }else if(strcmp(op, "!=") == 0){
                if(*(int*) (row + offset) != atoi(val)){
                    return_table[rt_index] = row;
                    rt_index++;
                }
            }
        }
    }
    struct Table returnStruct = {return_table, rt_index};

    return returnStruct;
}

struct Table delete_table(struct Table t, int offset, char* op, char* val, char* type_of_val){
    int size_p = t.size;
    void** p = t.ptr;
    void** return_table = malloc(sizeof(void*) * size_p);
    int rt_index = 0;
    for(int i = 0; i < size_p; i++){
        void* row = p[i];
        if(strcmp(type_of_val, "string") == 0){
            if(strcmp(op, "==") == 0){
                return where_table(t, offset, "!=", val, "string");
            }else if(strcmp(op, "!=") == 0){
                return where_table(t, offset, "==", val, "string");
            }
        }else if(strcmp(type_of_val, "int") == 0){
            if(strcmp(op, "==") == 0){
                return where_table(t, offset, "!=", val, "int");
            }else if(strcmp(op, "<=") == 0) {
                return where_table(t, offset, ">", val, "int");
            }else if (strcmp(op, ">=") == 0) {
                return where_table(t, offset, "<", val, "int");
            }else if (strcmp(op, "!=") == 0) {
                return where_table(t, offset, "=", val, "int");
            }else if (strcmp(op, ">") == 0) {
                return where_table(t, offset, "<=", val, "int");
            }else if(strcmp(op, "<") == 0) {
                return where_table(t, offset, ">=", val, "int");
            }
        }else if(strcmp(type_of_val, "float") == 0){
            if(strcmp(op, "==") == 0){
                return where_table(t, offset, "!=", val, "float");
            }else if(strcmp(op, "<=") == 0) {
                return where_table(t, offset, ">", val, "float");
            }else if (strcmp(op, ">=") == 0) {
                return where_table(t, offset, "<", val, "float");
            }else if (strcmp(op, "!=") == 0) {
                return where_table(t, offset, "==", val, "float");
            }else if (strcmp(op, ">") == 0) {
                return where_table(t, offset, "<=", val, "float");
            }else if(strcmp(op, "<") == 0) {
                return where_table(t, offset, ">=", val, "float");
            }
        }else if(strcmp(type_of_val, "boolean") == 0){
            if(strcmp(op, "==") == 0){
                return where_table(t, offset, "!=", val, "boolean");
            }else if(strcmp(op, "!=") == 0){
                return where_table(t, offset, "==", val, "boolean");
            }
        }
    }
}

char* int_to_string(int x){
    int length = snprintf( NULL, 0, "%d", x );
    char* str = malloc( length + 1 );
    snprintf( str, length + 1, "%d", x );
    return str;
}

char* float_to_string(float f){
    int length = snprintf( NULL, 0, "%f", f );
    char* str = malloc( length + 1 );
    snprintf( str, length + 1, "%f", f );
    return str;
}

char* bool_to_string(char b){
    char* s = b == 1 ? "true" : "false";
    int length = snprintf( NULL, 0, "%s", s);
    char* str = malloc( length + 1 );
    snprintf( str, length + 1, "%s",  s);
    return str;
}

int bool_to_int(char b){
    return b == 1 ? 1 : 0;
}

char* string_concat(char* s1, char*s2){
    int length = snprintf( NULL, 0, "%s", s1)+snprintf( NULL, 0, "%s", s2);
    char* element = malloc( length + 1 );
    strcat(element, s1);
    strcat(element, s2);
    return element;
}

struct Table insert_table(struct Table p,char** cells, char** type, int numberOfFields){
    void** pr = p.ptr;
    int size = p.size;
    int number = numberOfFields;
    int i=0,f=0,b=0,s=0,n;
    char** str = type;
    char *t1 = "int";
    char *t2 = "float";
    char *t3 = "boolean";
    char *t4 = "string";
    int tn[number];
    for(n=0; n<number ; n++){
        char *t5 = str[n];
        if (strcmp(t5, t1)==0){
            i++;
            tn[n] = 1;
        }
        if (strcmp(t5, t2)==0){
            f++;
            tn[n] = 2;
        }
        if (strcmp(t5, t3)==0){
            b++;
            tn[n] = 3;
        }
        if (strcmp(t5, t4)==0){
            s++;
            tn[n] = 4;
        }
    }

    int q;
    char *w;
    float r;
    char** c = cells;
    void** temp = pr;
    temp = temp + size;
    int v = sizeof(int);

    void* teq = malloc((i+f+b+2*s)*sizeof(int));
    *temp = teq;
    for(n=0;n<number;n++){
        if (tn[n] == 1){
            q = atoi(c[n]);
            *(int*)teq = q;
            teq = teq + v;
        }
        if (tn[n] == 4){
            w = c[n];
            *(char**)teq = w;
            teq = teq + 2*v;
        }
        if (tn[n] == 2){
            r = atof(c[n]);
            *(float*)teq = r;
            teq = teq + v;
        }
        if (tn[n] == 3){
            q = atoi(c[n]);
            *(int*)teq = q;
            teq = teq + v;
        }
    }
    size = size + 1;
    struct Table insertStruct = {pr, size};
    return insertStruct;
}