module ParseIO where
import Lib(Expr(..))
import Data.Array.Unboxed
import Language.CNF.Parse.ParseDIMACS

loadFile :: FilePath -> IO (Either String Expr)
loadFile fileName = do
  dimacsCNF <- parseFile fileName
  case dimacsCNF of
    Left _ -> return $ Left "Parse Error"
    Right cnf -> return $ Right $ cnfToExpr cnf

cnfToExpr :: CNF -> Expr
cnfToExpr cnf = andClauses exprList 
  where 
    exprList   = map uArraytoExpr $ clauses cnf
    
    andClauses :: [Expr] -> Expr
    andClauses []      = Const True
    andClauses [x]     = x
    andClauses [x,y,z] = And (And x y) z
    andClauses xs      = And (andClauses front) (andClauses back)
      where (front, back) = splitAt ((length xs + 1) `div` 2) xs 

-- Converts UArray (DIMACS format) to our ADT
uArraytoExpr :: UArray Int Int -> Expr
uArraytoExpr = orLiterals . (map intToExpr) . elems
  where
    intToExpr :: Int -> Expr
    intToExpr n | n > 0 = Var $ show n
    intToExpr n         = Not $ Var $ show $ abs n

    orLiterals :: [Expr] -> Expr
    orLiterals = foldr1 (\x acc -> Or x acc) 