module ParSolver where

import Lib
import Control.Parallel.Strategies(Strategy, using, rpar)
import Control.DeepSeq(NFData)

-- Wrapper for parallelizing the problem
satisfiable :: Expr -> Bool
satisfiable (Const b) = b
satisfiable orExpr@(Or _ _) = satisfiableDPLL orExpr
satisfiable (And x y) = and ([satisfiableDPLL x, satisfiableDPLL y] `using` pairParStrat)
satisfiable _ = undefined

satisfiableDPLL :: Expr -> Bool
satisfiableDPLL = satBase pairParStrat fixedDepth

pairParStrat :: (NFData a)=> Strategy [a]
pairParStrat [a,b] = do
    a' <- rpar a
    b' <- rpar b
    return [a', b']
pairParStrat _ = undefined

fixedDepth :: Int
fixedDepth = 40

-- In Parallel, evaluate TrueGuess and FalseGuess
-- recurses to a certain depth
satBase :: Strategy [Bool] -> Int -> Expr -> Bool
satBase _ 0 expr = satisfiableDPLLSeq expr
satBase strat depth expr =
    case freeVariable expr' of
        Nothing -> unConst $ simplify expr'
        Just v ->
          let trueGuess  = satBase strat depth' $ simplify (guessVariable v True expr')
              falseGuess = satBase strat depth' $ simplify (guessVariable v False expr')
          in or ([trueGuess, falseGuess] `using` strat)
    where
        depth' = depth - 1
        expr' = literalElimination $ fixNegations $ unitPropagation expr

-- sequential satisfiable function after the depth has been reached
satisfiableDPLLSeq :: Expr -> Bool
satisfiableDPLLSeq expr =
    case freeVariable expr' of
        Nothing -> unConst $ simplify expr'
        Just v ->
          let trueGuess = simplify (guessVariable v True expr')
              falseGuess = simplify (guessVariable v False expr')
          in satisfiableDPLLSeq trueGuess || satisfiableDPLLSeq falseGuess
    where
    -- Apply our backtracking search *after* literal elimination
    -- and unit propagation have been applied!
    expr' = literalElimination $ fixNegations $ unitPropagation expr
