-- reference 
-- https://stackoverflow.com/questions/52134945/could-not-find-module-data-set
-- https://andrew.gibiansky.com/blog/verification/writing-a-sat-solver/

module Main where

import ParSolver
import ParseIO

import System.Exit(die)
import System.Environment(getArgs, getProgName)


main :: IO ()
main = do
      args <- getArgs
      case args of
            [file] -> do
                  cnf <- loadFile file
                  case cnf of
                        Left err   -> putStrLn err
                        Right cnf' -> case satisfiableDPLL cnf' of
                              True -> putStrLn $ file ++ " is SATISFIABLE"
                              _    -> putStrLn $ file ++ " is UNSATISFIABLE"
            _ -> do
                  pn <- getProgName
                  die $ "Usage: " ++ pn ++ " <filename>"