module Main where

import Test.HUnit
import Lib
import qualified Data.Set as Set

testE2E :: Test
testE2E = TestCase (do
        content <- readFile "C:/Users/chiyo/Desktop/nonogram/puzzles/1.non"
        let info = init.tail $ dropWhile (/="") $ lines content
        let h = map (\line -> clean line ) $ tail $ takeWhile (/= "") info
        let v = map (\line -> clean line ) $ tail $ filter (/= "") (dropWhile (/= "") info)
        assertEqual "horizontal grid," [[2],[2,1],[1,1],[3],[1,1],[1,1],[2],[1,1],[1,2],[2]] h
        assertEqual "vertical grid," [[2,1],[2,1,3],[7],[1,3],[2,1]] v 
        assertEqual "solution for puzzle 1.non," "[01100]\n[01101]\n[00101]\n[01110]\n[10100]\n[10100]\n[00110]\n[01010]\n[01011]\n[11000]\n" $ show $ head $ solve (puzzle h v))


testInvalid :: Test
testInvalid = TestCase (do
        assertEqual "test invalid puzzle" "False" $ show $ check $ solve (puzzle [[2],[2]] [[5],[5]])
    )

testOrder :: Test
testOrder = TestCase (do
        assertEqual "possible line values" (map Value [-1,-1, 1, -2,-2, 2,3, -4,-4, 4,5,6, -7,-7, 7, 8, 9, 10, -11, -11]) $ order [1,2,3,4]
    )

testFilterCell :: Test
testFilterCell = TestCase (do
        let filterSol = Set.fromList $ map Value [2]
        let noneFiltered = Set.fromList $ map Value [2,1]
        assertEqual "filtering cells" (filterSol, noneFiltered) $ filterCell full (Set.fromList $ map Value [-8,-7,-1,2], noneFiltered)
    )

testSS :: Test
testSS = TestCase (do
        let filterSol = Set.fromList $ map Value [-2,2,3]
        let noneFiltered = Set.fromList $ map Value [-2]
        assertEqual "double filtering single cell" (noneFiltered, noneFiltered) $ singleStep filterSol noneFiltered
    )

testZMap :: Test
testZMap = TestCase (do
        let sol = ["ad", "bcef"]
        let result = zMap (\x y -> (x++y, x++y)) ["a", "bc"] ["d", "ef"]
        assertEqual "simply zip map example" (sol, sol) result
    )

testConsecSame :: Test
testConsecSame = TestCase (do
        let p1 = (puzzle [[1],[2],[3,4]] [[1],[2],[3,4]])
        let p2 = (puzzle [[5],[9],[3,4]] [[5],[9],[3,4]])
        assertEqual "only first consecutive puzzles are returned" p1 $ consecSame [p1, p1, p2, p2]
    )

tests :: Test
tests = TestList [TestLabel "testE2E" testE2E, TestLabel "testOrder" testOrder, TestLabel "testFilterCell" testFilterCell,
                  TestLabel "testSS" testSS, TestLabel "testZMap" testZMap, TestLabel "testInvalid" testInvalid ]

main :: IO Counts
main = do
          runTestTT tests
