module Main where

import Lib
import System.Exit(die)
import System.Environment(getArgs, getProgName)
import System.Directory (getDirectoryContents)
import Control.Parallel.Strategies (parMap, rdeepseq)


-- Second main: Sequentially reads all the contents of all the files
-- Reads all the puzzles in the absolute path because Haskell sucks
main :: IO()
main = do 
    args <- getArgs
    case args of
        [pathname] -> do
            let path = pathname ++ "/puzzles/"
            files <- getDirectoryContents path
            let onlyFiles = filter (`notElem` [".",".."]) files
            let absoluteFiles = map (path ++ ) onlyFiles
            contents <- mapM readFile absoluteFiles
            let solutions = parMap rdeepseq nonogram contents  -- solutions is of type [Bool]
            print (length (filter (== True)  solutions ))
        _ -> do 
            pn <- getProgName
            die $ "Usage: " ++ pn ++ " <path_to_current_directory>"

