#!/bin/bash

rm -rf eventlogs
mkdir eventlogs

files=(5 10 20)
threads=(1 2 4)

for file in ${files[@]}
do
    for thread in ${threads[@]}
    do
        printf "\n\n-----------------------------------\n"
        printf "$file x $file - $thread threads\n"
        time ./nonogram_solver tests/$file.txt +RTS -N$thread -ls
        mv nonogram_solver.eventlog eventlogs/$file-$thread.eventlog
    done
done
