module Main where
import Graphics.Gloss
import Tree
import Render
import System.Environment(getArgs)
import TestPoints
import System.Exit

maxDistance :: Float
maxDistance = 60.0

minDistance :: Float
minDistance = 5.0;

simulationLoop :: Tree -> IO ()
simulationLoop (DONE _) = putStrLn "Done"
simulationLoop tree = simulationLoop (nextBranch True True tree)


window :: Display
window = InWindow "Tree" (500, 500) (0, 0)

backgroundColor :: Color
backgroundColor = makeColor 255 255 255 255

startTree :: Tree
startTree = initialTree testPoints 500 maxDistance minDistance


main :: IO ()
main = do args <- getArgs
          case args of
              [maxDist,minDist,speed] -> simulate window backgroundColor (read speed :: Int) (initialTree testPoints 500 (read maxDist :: Float) (read minDist :: Float)) treeAsPicture nextBranch
              [maxDist,minDist] -> simulationLoop (initialTree testPoints 500 (read maxDist :: Float) (read minDist :: Float))
              _ -> putStrLn "Usage ./tree-exe maxDist minDist <simulation_display_speed>" >> exitSuccess
