module EnigmaTestStatic where

import Enigma
import Enigma.Static

rotorIDWiring :: Wiring
rotorIDWiring = getWiring "id"

rotorIWiring :: Wiring
rotorIWiring = getWiring "I"

invRotorIWiring :: Wiring
invRotorIWiring = invertWiring rotorIWiring

rotorIIWiring :: Wiring
rotorIIWiring = getWiring "II"

invRotorIIWiring :: Wiring
invRotorIIWiring = invertWiring rotorIIWiring

rotorIIIWiring :: Wiring
rotorIIIWiring = getWiring "III"

rotorIVWiring :: Wiring
rotorIVWiring = getWiring "IV"

refBWiring :: Wiring
refBWiring = getWiring "refB"

refCWiring :: Wiring
refCWiring = getWiring "refC"

plugboardA :: Plugboard
plugboardA = [('A', 'Z'), ('X', 'Y'), ('O', 'E')]

plugboardB :: Plugboard
plugboardB = [('Z', 'A'), ('Y', 'X')]

rotorI :: Rotor
rotorI = getRotor "I"

rotorII :: Rotor
rotorII = getRotor "II"

rotorIII :: Rotor
rotorIII = getRotor "III"

rotorIV :: Rotor
rotorIV = getRotor "IV"

rotorBeta :: Rotor
rotorBeta = getRotor "beta"

idConfig :: EnigmaConfig
idConfig =
  EnigmaConfig
    { reflector = rotorIDWiring,
      rotors = [],
      plugboard = []
    }

configA :: EnigmaConfig
configA =
  EnigmaConfig
    { reflector = refBWiring,
      rotors =
        [ OrientedRotor {rotor = rotorI, topLetter = 'A', ringSetting = 'A'},
          OrientedRotor {rotor = rotorII, topLetter = 'A', ringSetting = 'A'},
          OrientedRotor {rotor = rotorIII, topLetter = 'A', ringSetting = 'A'}
        ],
      plugboard = []
    }

configB :: EnigmaConfig
configB =
  EnigmaConfig
    { reflector = refBWiring,
      rotors =
        [ OrientedRotor {rotor = rotorIII, topLetter = 'Z', ringSetting = 'A'},
          OrientedRotor {rotor = rotorII, topLetter = 'Q', ringSetting = 'A'},
          OrientedRotor {rotor = rotorI, topLetter = 'B', ringSetting = 'A'}
        ],
      plugboard = plugboardA
    }

stepCfgA :: EnigmaConfig
stepCfgA =
  EnigmaConfig
    { reflector = refBWiring,
      rotors =
        [ OrientedRotor {rotor = rotorIII, topLetter = 'K', ringSetting = 'A'},
          OrientedRotor {rotor = rotorII, topLetter = 'D', ringSetting = 'A'},
          OrientedRotor {rotor = rotorI, topLetter = 'O', ringSetting = 'A'}
        ],
      plugboard = []
    }

stepCfgA' :: EnigmaConfig
stepCfgA' =
  EnigmaConfig
    { reflector = refBWiring,
      rotors =
        [ OrientedRotor {rotor = rotorIII, topLetter = 'K', ringSetting = 'A'},
          OrientedRotor {rotor = rotorII, topLetter = 'D', ringSetting = 'A'},
          OrientedRotor {rotor = rotorI, topLetter = 'P', ringSetting = 'A'}
        ],
      plugboard = []
    }

-- CfgA stepped 3 times
stepCfgA3 :: EnigmaConfig
stepCfgA3 =
  EnigmaConfig
    { reflector = refBWiring,
      rotors =
        [ OrientedRotor {rotor = rotorIII, topLetter = 'K', ringSetting = 'A'},
          OrientedRotor {rotor = rotorII, topLetter = 'E', ringSetting = 'A'},
          OrientedRotor {rotor = rotorI, topLetter = 'R', ringSetting = 'A'}
        ],
      plugboard = []
    }

stepCfgB :: EnigmaConfig
stepCfgB =
  EnigmaConfig
    { reflector = refBWiring,
      rotors =
        [ OrientedRotor {rotor = rotorIV, topLetter = 'I', ringSetting = 'A'},
          OrientedRotor {rotor = rotorIII, topLetter = 'K', ringSetting = 'A'},
          OrientedRotor {rotor = rotorII, topLetter = 'D', ringSetting = 'A'},
          OrientedRotor {rotor = rotorI, topLetter = 'O', ringSetting = 'A'}
        ],
      plugboard = []
    }

plugCfgA :: EnigmaConfig
plugCfgA =
  EnigmaConfig
    { reflector = refBWiring,
      rotors =
        [ OrientedRotor {rotor = rotorIII, topLetter = 'R', ringSetting = 'A'},
          OrientedRotor {rotor = rotorII, topLetter = 'F', ringSetting = 'A'},
          OrientedRotor {rotor = rotorI, topLetter = 'Z', ringSetting = 'A'}
        ],
      plugboard = plugboardA
    }

ringCfgA :: EnigmaConfig
ringCfgA =
  EnigmaConfig
    { reflector = refBWiring,
      rotors =
        [ makeOriented "II" 'F' 'D',
          makeOriented "I" 'K' 'F',
          makeOriented "III" 'L' 'B'
        ],
      plugboard = []
    }