# Parallel Enigma Solver

Samuel Meshoyrer sm3604

Evan Mesterhazy etm2131


```
$ stack build  # build the project
$ stack test   # run the unit tests 

$ stack exec -- denigma-exe -h
Usage: denigma-exe COMMAND

Available options:
  -h,--help                Show this help text

Available commands:
  encrypt                  Encrypt the file
  decryptSequential        Decrypt the file sequentially
  decryptParBuffer         Decrypt the file with a parBuffer limited to the
                           given size; use quotes: e.g. "1000 /path/to/file"
  decryptRDeepSeq          Decrypt the file with parList rDeepSeq
  decryptRSeq              Decrypt the file with parList rSeq
  decryptRPar              Decrypt the file with parList rPar
  decryptSixWay            Decrypt the file with a static six-way partition
  decryptChunks            Decrypt the file with parListChunk 1000 rdeepseq
  decryptBufferChunks      Decrypt the file in chunks of 1000 with parBuffer 128
```

Example Usage 

```
$ stack exec -- denigma-exe encrypt plain.txt > cipher.txt
$ stack exec -- denigma-exe decryptParBuffer "1000 cipher.txt"   
$ stack exec -- denigma-exe decryptSequential cipher.txt  
```
