{-
Parallel No Alpha-Beta pruning implementation of functions, uses backgammon.hs module
Check Project report for explaination of each function.
-}

import Backgammon
import Control.Parallel.Strategies(using, parList, rdeepseq)
import Control.DeepSeq(NFData)
import Data.List(sortBy)
import System.Environment(getArgs)


bestMovePar :: (Eq a, Num a) => Board -> (Die, Die) -> Side -> a -> Int -> [Move]
bestMovePar board diceRoll side depth pruningDepth = bestMovePar' forwardPruningMoves where
  allLegalMoves = legalMoves board diceRoll side
  forwardPruningMoves = forwardPruning board side allLegalMoves pruningDepth
  bestMovePar' mvs = snd $ head $ sortBy (\x y -> compare (fst x) (fst y)) (bestMoveParAll mvs)
  bestMoveParAll mvs = map innerFunc mvs `using` parList rdeepseq
  innerFunc mv = case (performMoves board side mv) of
    (Left _) -> (((1/0)::Double),mv)
    (Right upBoard) -> ((-1*expectiRes), mv) where
      expectiRes = expectinodePar upBoard side (opposite side) ((-1/0)::Double) (1/0) depth pruningDepth

expectinodePar :: (Eq a, Num a) => Board -> Side -> Side -> p1 -> p2 -> a -> Int -> Double
expectinodePar board side _ _ _ 0 _ = fromIntegral $ eval board side
expectinodePar board side currSide alpha beta depth pruningDepth
  | side==currSide = sum $ sumAllDice minValuePar
  | otherwise = sum $ sumAllDice maxValuePar where
    sumAllDice func = map (\diceRoll -> (multiplier diceRoll) *
                                  func board side currSide diceRoll alpha beta depth pruningDepth) allDiceRolls
                                  `using` parList rdeepseq
    multiplier (d1,d2) = if (d1==d2) then (1/36) else (1/18)

minValuePar :: (Eq a, Num a) => Board -> Side -> Side -> (Die, Die) -> p1 -> p2 -> a -> Int -> Double
minValuePar board side currSide diceRoll alpha beta depth pruningDepth
  | length allLegalMoves > 0 = minValuePar' forwardPruningMoves
  | otherwise = expectinodePar board side (opposite currSide) alpha beta (depth-1) pruningDepth where
    allLegalMoves = legalMoves board diceRoll currSide
    forwardPruningMoves = forwardPruning board currSide allLegalMoves pruningDepth
    minValuePar' mvs = fst $ head $ sortBy (\x y -> compare (fst x) (fst y)) (minValueParAll mvs)
    minValueParAll mvs = map innerFunc mvs `using` parList rdeepseq
    innerFunc mv = case (performMoves board currSide mv) of
      (Left _) -> (((1/0)::Double),mv)
      (Right newBoard) -> ((expectiRes), mv) where
        expectiRes = expectinodePar newBoard side (opposite currSide) alpha beta (depth-1) pruningDepth

maxValuePar :: (Eq a, Num a) => Board -> Side -> Side -> (Die, Die) -> p1 -> p2 -> a -> Int -> Double
maxValuePar board side currSide diceRoll alpha beta depth pruningDepth
  | length allLegalMoves > 0 = maxValuePar' forwardPruningMoves
  | otherwise = expectinodePar board side (opposite currSide) alpha beta (depth-1) pruningDepth where
    allLegalMoves = legalMoves board diceRoll currSide
    forwardPruningMoves = forwardPruning board currSide allLegalMoves pruningDepth
    maxValuePar' mvs = fst $ head $ sortBy (\x y -> compare (fst x) (fst y)) (maxValueParAll mvs)
    maxValueParAll mvs = map innerFunc mvs `using` parList rdeepseq
    innerFunc mv = case (performMoves board currSide mv) of
      (Left _) -> (((1/0)::Double),mv)
      (Right newBoard) -> ((-1*expectiRes), mv) where
        expectiRes = expectinodePar newBoard side (opposite currSide) alpha beta (depth-1) pruningDepth

main :: IO()
main = do
  args <- getArgs
  let side = read $ head args :: Side
  let restArgs = map (\x -> (read x :: Int)) (tail args)
  let depth = (restArgs !! 0)
  let pruningDepth = (restArgs !! 1)
  let seed = (restArgs !! 2)
  let ans = gamePlay side depth pruningDepth seed bestMovePar
  print $ ans
