{-
Sequential implementation of functions, uses backgammon.hs module
Check Project report for explaination of each function.
-}

import Backgammon
import System.Environment(getArgs)

bestMove :: Board -> Dice -> Side -> Int -> Int -> [Move]
bestMove board diceRoll side depth pruningDepth = bestMove' forwardPruningMoves (-1/0) [] where
  allLegalMoves = legalMoves board diceRoll side
  forwardPruningMoves = forwardPruning board side allLegalMoves pruningDepth
  bestMove' :: (Ord t, Fractional t) => [[Move]] -> t -> [Move] -> [Move]
  bestMove' [] _ bestMoveA = bestMoveA
  bestMove' (mv:mvs) bestScore bestMoveA = case (performMoves board side mv) of
    (Left _) -> bestMove' mvs bestScore bestMoveA
    (Right upBoard) -> bestMove' mvs newBestScore newBestMove where
      expectiRes = expectinode upBoard side (opposite side) bestScore (1/0) depth pruningDepth
      newBestScore = if (expectiRes>bestScore) then expectiRes else bestScore
      newBestMove = if (expectiRes>bestScore) then mv else bestMoveA


expectinode :: (Ord t, Fractional t) => Board -> Side -> Side -> t -> t -> Int -> Int -> t
expectinode board side _ _ _ 0 _ = fromIntegral $ eval board side
expectinode board side currSide alpha beta depth pruningDepth
  | side==currSide = sumAllDice minValue
  | otherwise = sumAllDice maxValue where
    sumAllDice func = sum [(multiplier diceRoll)*(func board side currSide diceRoll alpha beta depth pruningDepth)
                            | diceRoll <- allDiceRolls]
    multiplier (d1,d2) = if (d1==d2) then (1/36) else (1/18)

minValue :: (Fractional t, Ord t) => Board -> Side -> Side -> Dice -> t -> t -> Int -> Int -> t
minValue board side currSide diceRoll alpha beta depth pruningDepth
  | length allLegalMoves > 0 = minValue' forwardPruningMoves alpha beta (1/0)
  | otherwise = expectinode board side (opposite currSide) alpha beta (depth-1) pruningDepth where
    allLegalMoves = legalMoves board diceRoll currSide
    forwardPruningMoves = forwardPruning board currSide allLegalMoves pruningDepth
    minValue' :: (Ord t, Fractional t) => [[Move]] -> t -> t -> t -> t
    minValue' [] _ _ bestScore = bestScore
    minValue' (mv:mvs) al bt bestScore = case (performMoves board currSide mv) of
      (Left _) -> minValue' mvs al bt bestScore
      (Right newBoard) -> if newBestScore <= al
                          then newBestScore
                          else minValue' mvs al newBt newBestScore where
        expectiRes = expectinode newBoard side (opposite currSide) al bt (depth-1) pruningDepth
        newBestScore = min bestScore expectiRes
        newBt = min bt newBestScore

maxValue :: (Fractional t, Ord t) => Board -> Side -> Side -> Dice -> t -> t -> Int -> Int -> t
maxValue board side currSide diceRoll alpha beta depth pruningDepth
  | length allLegalMoves > 0 = maxValue' forwardPruningMoves alpha beta (-1/0)
  | otherwise = expectinode board side (opposite currSide) alpha beta (depth-1) pruningDepth where
    allLegalMoves = legalMoves board diceRoll currSide
    forwardPruningMoves = forwardPruning board currSide allLegalMoves pruningDepth
    maxValue' :: (Ord t, Fractional t) => [[Move]] -> t -> t -> t -> t
    maxValue' [] _ _ bestScore = bestScore
    maxValue' (mv:mvs) al bt bestScore = case (performMoves board currSide mv) of
      (Left _) -> maxValue' mvs al bt bestScore
      (Right newBoard) -> if newBestScore >= bt
                          then newBestScore
                          else maxValue' mvs newAl bt newBestScore where
        expectiRes = expectinode newBoard side (opposite currSide) al bt (depth-1) pruningDepth
        newBestScore = max bestScore expectiRes
        newAl = max al newBestScore

main :: IO()
main = do
  args <- getArgs
  let side = read $ head args :: Side
  let restArgs = map (\x -> (read x :: Int)) (tail args)
  let depth = (restArgs !! 0)
  let pruningDepth = (restArgs !! 1)
  let seed = (restArgs !! 2)
  let ans = gamePlay side depth pruningDepth seed bestMove
  print $ ans
