{-
Parallel implementation of functions, uses backgammon.hs module
Check Project report for explaination of each function.
-}


import Backgammon
import Control.Parallel.Strategies(using, parList, rdeepseq)
import Control.DeepSeq(NFData)
import System.Environment(getArgs)

bestMovePar :: Board -> Dice -> Side -> Int -> Int -> [Move]
bestMovePar board diceRoll side depth pruningDepth = bestMovePar' forwardPruningMoves ((-1/0)::Double) [] where
  allLegalMoves = legalMoves board diceRoll side
  forwardPruningMoves = forwardPruning board side allLegalMoves pruningDepth
  bestMovePar' :: (Ord t, Fractional t, NFData t, Num t) => [[Move]] -> t -> [Move] -> [Move]
  bestMovePar' [] _ bestMoveA = bestMoveA
  bestMovePar' (mv:mvs) bestScore bestMoveA = case (performMoves board side mv) of
    (Left _) -> bestMovePar' mvs bestScore bestMoveA
    (Right upBoard) -> bestMovePar' mvs newBestScore newBestMove where
      expectiRes = expectinodePar upBoard side (opposite side) bestScore (1/0) depth pruningDepth
      newBestScore = if (expectiRes>bestScore) then expectiRes else bestScore
      newBestMove = if (expectiRes>bestScore) then mv else bestMoveA

expectinodePar :: (Fractional a, NFData a, Ord a) => Board -> Side -> Side -> a -> a -> Int -> Int -> a
expectinodePar board side _ _ _ 0 _ = fromIntegral $ eval board side
expectinodePar board side currSide alpha beta depth pruningDepth
  | side==currSide = sum $ sumAllDice minValuePar
  | otherwise = sum $ sumAllDice maxValuePar where
    sumAllDice func = map (\diceRoll -> (multiplier diceRoll) *
                                  func board side currSide diceRoll alpha beta depth pruningDepth) allDiceRolls
                                  `using` parList rdeepseq
    multiplier (d1,d2) = if (d1==d2) then (1/36) else (1/18)

minValuePar :: (Fractional t, Ord t, NFData t) => Board -> Side -> Side -> Dice -> t -> t -> Int -> Int -> t
minValuePar board side currSide diceRoll alpha beta depth pruningDepth
  | length allLegalMoves > 0 = minValuePar' forwardPruningMoves alpha beta (1/0)
  | otherwise = expectinodePar board side (opposite currSide) alpha beta (depth-1) pruningDepth where
    allLegalMoves = legalMoves board diceRoll currSide
    forwardPruningMoves = forwardPruning board currSide allLegalMoves pruningDepth
    minValuePar' :: (Ord t, Fractional t, NFData t) => [[Move]] -> t -> t -> t -> t
    minValuePar' [] _ _ bestScore = bestScore
    minValuePar' (mv:mvs) al bt bestScore = case (performMoves board currSide mv) of
      (Left _) -> minValuePar' mvs al bt bestScore
      (Right newBoard) -> if newBestScore <= al
                          then newBestScore
                          else minValuePar' mvs al newBt newBestScore where
        expectiRes = expectinodePar newBoard side (opposite currSide) al bt (depth-1) pruningDepth
        newBestScore = min bestScore expectiRes
        newBt = min bt newBestScore

maxValuePar :: (Fractional t, Ord t, NFData t) => Board -> Side -> Side -> Dice -> t -> t -> Int -> Int -> t
maxValuePar board side currSide diceRoll alpha beta depth pruningDepth
  | length allLegalMoves > 0 = maxValuePar' forwardPruningMoves alpha beta (-1/0)
  | otherwise = expectinodePar board side (opposite currSide) alpha beta (depth-1) pruningDepth where
    allLegalMoves = legalMoves board diceRoll currSide
    forwardPruningMoves = forwardPruning board currSide allLegalMoves pruningDepth
    maxValuePar' :: (Ord t, Fractional t, NFData t) => [[Move]] -> t -> t -> t -> t
    maxValuePar' [] _ _ bestScore = bestScore
    maxValuePar' (mv:mvs) al bt bestScore = case (performMoves board currSide mv) of
      (Left _) -> maxValuePar' mvs al bt bestScore
      (Right newBoard) -> if newBestScore >= bt
                          then newBestScore
                          else maxValuePar' mvs newAl bt newBestScore where
        expectiRes = expectinodePar newBoard side (opposite currSide) al bt (depth-1) pruningDepth
        newBestScore = max bestScore expectiRes
        newAl = max al newBestScore

main :: IO()
main = do
  args <- getArgs
  let side = read $ head args :: Side
  let restArgs = map (\x -> (read x :: Int)) (tail args)
  let depth = (restArgs !! 0)
  let pruningDepth = (restArgs !! 1)
  let seed = (restArgs !! 2)
  let ans = gamePlay side depth pruningDepth seed bestMovePar
  print $ ans
