// Author: Kevin Li

#include <stdio.h>
#include <stdlib.h>
#include <asm-generic/int-ll64.h>
#include <unistd.h>
#include <time.h>
#include "tetris.h"
#include <string.h>

board_t
piece_and_board (int (*board)[HEIGHT][WIDTH], int (*piece)[HEIGHT][WIDTH])
{
  board_t res = 0;
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  res |= (((*board)[i][j] | (*piece)[i][j]) & 1UL) << (i * WIDTH + j);
	}
    }
  return res;
}

void
print_matrix (int (*matrix)[HEIGHT][WIDTH])
{
  printf ("*******\n");
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  printf ("%d", (*matrix)[i][j]);
	}
      printf ("\n");
    }
  printf ("*******\n");
}

void
print_piece_and_board (board_t res)
{
  printf ("%lu\n", res);
  printf ("--------\n");
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if ((res >> (i * WIDTH + j)) & 1UL)
	    printf ("1");
	  else
	    printf ("0");
	}
      printf ("\n");
    }
  printf ("--------\n");
}

void
settle_piece (int (*board)[HEIGHT][WIDTH], int (*piece)[HEIGHT][WIDTH])
{
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if ((*piece)[i][j])
	    (*board)[i][j] |= 1;
	}
    }
}

int
collision (int (*board)[HEIGHT][WIDTH], int (*piece)[HEIGHT][WIDTH])
{
  for (int i = 0; i < HEIGHT - 1; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if ((*board)[i + 1][j] && (*piece)[i][j])
	    {
	      return 1;
	    }
	}
    }
  for (int j = 0; j < WIDTH; ++j)
    {
      if ((*piece)[HEIGHT - 1][j])
	{
	  return 1;
	}
    }
  return 0;
}

void
piece_down (int (*piece)[HEIGHT][WIDTH])
{
  int nextpiece[HEIGHT][WIDTH];
  memset (nextpiece, 0, sizeof (int) * HEIGHT * WIDTH);
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if ((*piece)[i][j])
	    {
	      nextpiece[i + 1][j] = 1;
	    }
	}
    }
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if (nextpiece[i][j])
	    {
	      (*piece)[i][j] = 1;
	    }
	  else
	    {
	      (*piece)[i][j] = 0;
	    }
	}
    }
}

void
piece_left (int (*board)[HEIGHT][WIDTH], int (*piece)[HEIGHT][WIDTH])
{
  int nextpiece[HEIGHT][WIDTH];
  memset (nextpiece, 0, sizeof (int) * HEIGHT * WIDTH);
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if ((*piece)[i][j])
	    {
	      if (j == 0 || (*board)[i][j-1])
		return;
	      nextpiece[i][j - 1] = 1;
	    }
	}
    }
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if (nextpiece[i][j])
	    {
	      (*piece)[i][j] = 1;
	    }
	  else
	    {
	      (*piece)[i][j] = 0;
	    }
	}
    }
}

void
piece_right (int (*board)[HEIGHT][WIDTH], int (*piece)[HEIGHT][WIDTH])
{
  int nextpiece[HEIGHT][WIDTH];
  memset (nextpiece, 0, sizeof (int) * HEIGHT * WIDTH);
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if ((*piece)[i][j])
	    {
	      if (j == WIDTH - 1 || (*board)[i][j+1])
		return;
	      nextpiece[i][j + 1] = 1;
	    }
	}
    }
  for (int i = 0; i < HEIGHT; ++i)
    {
      for (int j = 0; j < WIDTH; ++j)
	{
	  if (nextpiece[i][j])
	    {
	      (*piece)[i][j] = 1;
	    }
	  else
	    {
	      (*piece)[i][j] = 0;
	    }
	}
    }
}

void
new_piece (int (*piece)[HEIGHT][WIDTH])
{
  int random;
  random = rand () % 7;
  printf ("rand: %d\n", random);
  memset (*piece, 0, sizeof (int) * HEIGHT * WIDTH);
  switch (random)
    {
    case 0:			// O
      (*piece)[0][0] = (*piece)[0][1] = (*piece)[1][0] = (*piece)[1][1] = 1;
      break;
    case 1:			// T
      (*piece)[0][1] = (*piece)[1][0] = (*piece)[1][1] = (*piece)[1][2] = 1;
      break;
    case 2:			// L
      (*piece)[0][0] = (*piece)[1][0] = (*piece)[1][1] = (*piece)[1][2] = 1;
      break;
    case 3:			// J
      (*piece)[0][2] = (*piece)[1][0] = (*piece)[1][1] = (*piece)[1][2] = 1;
      break;
    case 4:			// I 
      (*piece)[0][0] = (*piece)[0][1] = (*piece)[0][2] = (*piece)[0][3] = 1;
      break;
    case 5:			// S
      (*piece)[0][0] = (*piece)[0][1] = (*piece)[1][1] = (*piece)[1][2] = 1;
      break;
    case 6:			// Z
      (*piece)[0][0] = (*piece)[0][1] = (*piece)[1][1] = (*piece)[1][2] = 1;
      break;
    }
}
