/*
 * Userspace program that communicates with the vga_ball device driver
 * through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include <stdlib.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <stdint.h>
#include <pthread.h>
#include "tetris.h"

#include <asm-generic/int-ll64.h>
#include "usbkeyboard.h"


int vga_ball_fd;

struct libusb_device_handle *keyboard;
uint8_t endpoint_address;


/* Read and print the background color */
void print_background_color() {
  vga_ball_arg_t vla;
  
  if (ioctl(vga_ball_fd, VGA_BALL_READ_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_READ_BACKGROUND) failed");
      return;
  }
  printf("%lu\n",
	  vla.bitmap.bits);
}

/* Set the background color */
void set_background_color(vga_ball_bitmap_t *c)
{
  vga_ball_arg_t vla;
  vla.bitmap = *c;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
      return;
  }
}

void write_state(board_t state) 
{
  vga_ball_bitmap_t test = {state};
  set_background_color(&test);
  print_background_color();
}

struct thread_info {
  int movement;
};

void *
keyboard_thread_f (void *args_v) {
  struct thread_info *args = (struct thread_info *)args_v;
  struct usb_keyboard_packet packet;
  int transferred;
  char keystate[12];

    /* Open the keyboard */
  if ( (keyboard = openkeyboard(&endpoint_address)) == NULL ) {
    fprintf(stderr, "Did not find a keyboard\n");
    exit(1);
  }

  for(;;) {

    libusb_interrupt_transfer(keyboard, endpoint_address,
      (unsigned char *) &packet, sizeof(packet),
      &transferred, 0);
    if (transferred == sizeof(packet)) {
      sprintf(keystate, "%02x %02x %02x", packet.modifiers, packet.keycode[0],
        packet.keycode[1]);
      if (packet.keycode[0] == 80) { // Left
        printf("LEFT!!!!!\n");
        args->movement = 1;
      } else if (packet.keycode[0] == 79) { // Right
        printf("RIGHTT!!!!\n");
        args->movement = 2;

        }
    }
  }
}

void play_tetris()
{

  pthread_t keyboard_thread;

  struct thread_info *args = malloc(sizeof(struct thread_info));
  args->movement = 0;

  pthread_create(&keyboard_thread, 0, &keyboard_thread_f, args);

  int board[HEIGHT][WIDTH];
  int piece[HEIGHT][WIDTH];
  board_t res;
  memset (&board, 0, sizeof (int) * HEIGHT * WIDTH);
  res = piece_and_board (&board, &piece);
  write_state (res);
  new_piece (&piece);
  for (int i = 0;;i += 500)
    {
      if (args->movement) {
        if (args->movement == 1) {
          piece_left(&board, &piece);
        }
        else if (args->movement == 2) {
          piece_right(&board, &piece);
        }
        args->movement = 0;
        res = piece_and_board (&board, &piece);
        write_state (res);
        print_piece_and_board(res);
      }

      if (i % 1000000 == 0) {
        if (collision (&board, &piece))
        {
          settle_piece (&board, &piece);
          new_piece (&piece);
        }
            else
        {
          piece_down (&piece);
        }

        res = piece_and_board (&board, &piece);
        write_state (res);
        print_piece_and_board(res);
      }

      usleep (500);
    }
}

int main()
{
  vga_ball_arg_t vla;
  int i;
  static const char filename[] = "/dev/vga_ball";


  /** if ( (keyboard = openkeyboard(&endpoint_address)) == NULL ) {
    fprintf(stderr, "Did not find a keyboard\n");
    exit(1);
  } **/


  // static const vga_ball_color_t colors[] = {
  //   { 0xff, 0x00, 0x00 }, /* Red */
  //   { 0x00, 0xff, 0x00 }, /* Green */
  //   { 0x00, 0x00, 0xff }, /* Blue */
  //   { 0xff, 0xff, 0x00 }, /* Yellow */
  //   { 0x00, 0xff, 0xff }, /* Cyan */
  //   { 0xff, 0x00, 0xff }, /* Magenta */
  //   { 0x80, 0x80, 0x80 }, /* Gray */
  //   { 0x00, 0x00, 0x00 }, /* Black */
  //   { 0xff, 0xff, 0xff }  /* White */
  // };

//vga_ball_bitmap_t test = {430};

# define COLORS 9

  printf("VGA ball Userspace program started\n");

  if ( (vga_ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  printf("initial state: ");

  /** for(;;){
    libusb_interrupt_transfer(keyboard, endpoint_address,
          (unsigned char *) &packet, sizeof(packet),
          &transferred, 0);
    if (transferred == sizeof(packet)){
      offset = 93;

      keycode0Int = packet.keycode[0] + offset;
      keycode1Int = packet.keycode[1] + offset;

      if (keycode0Int == 133){ // Enter pressed
          printf("Enter pressed\n");
          //set_background_color(&test[0]);
      }
    }

  } **/

  play_tetris();
  

  printf("VGA BALL Userspace program terminating\n");
  return 0;
}

