/*
 * Adapted from Klahn, Gregory, Bonilla
 * MIT 6.111 Fall 2019
 * 
*/
module vram_spoofer(
		   input logic 	      clock_in,
		   input logic 	      reset_in,
		   input logic [15:0] addr_in,
		   output logic [7:0] data_out
		   );

	parameter NAMETABLE_LOWER_BOUND = 16'h2000;
	parameter NAMETABLE_UPPER_BOUND = 16'h23C0;

	parameter ATTRIBUTE_BYTE = 8'b01_01_01_01;
	parameter ATTRIBUTE_LOWER_BOUND = 16'h23C0;
	parameter ATTRIBUTE_UPPER_BOUND = 16'h2400;

	parameter DEFAULT_BYTE = 8'hFF;
	
	typedef struct packed {
		logic[7:0][7:0] pattern_bytes_1;
		logic[7:0][7:0] pattern_bytes_2;
	} Tile; 
	
	parameter NUM_TILES_LOADED = 7;
	parameter MAX_VALID_PATTERN_TABLE_ADDRESS = NUM_TILES_LOADED * 16 - 1;
	
	//This need to change if you are adding or removing tiles
   Tile pattern_table_0;
   Tile pattern_table_1;
   Tile pattern_table_2;
   Tile pattern_table_3;
   Tile pattern_table_4;
   Tile pattern_table_5;
   Tile pattern_table_6;
   Tile pattern_table_7;
	
   assign pattern_table_0.pattern_bytes_1 = {8'b00111100,
					      8'b01111110,
					      8'b00000000,
					      8'b00000000,
					      8'b00000000,
					      8'b00000000,
					      8'b00000000,
					      8'b00000000
					      };
   

   assign pattern_table_0.pattern_bytes_2 = {8'b00000000,
					      8'b01000010,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b01111110,
					      8'b01111110,
					      8'b00111100
					      };
   
   assign pattern_table_2.pattern_bytes_1 = {8'b000000000,
					      8'b00000000,
					      8'b00000000,
					      8'b00000000, //finished here
					      8'b00000000,
					      8'b00000000,
					      8'b00000000,
					      8'b00000000
					      };
   assign pattern_table_2.pattern_bytes_2 = {8'b00000000, //A
					      8'b11000110,
					      8'b11000110,
					      8'b11111110,
					      8'b11000110,
					      8'b11000110,
					      8'b01101100,
					      8'b00111000
					      };

   assign pattern_table_1.pattern_bytes_2 = {8'b000000000,
					     8'b00000000,
					     8'b00000000,
					     8'b00000000, //finished here
					     8'b00000000,
					     8'b00000000,
					     8'b00000000,
					     8'b00000000

					      };
   assign pattern_table_1.pattern_bytes_1 = {8'b00000000, //G
					      8'b0111110,
					      8'b01100110,
					      8'b11000110,
					      8'b11011110,
					      8'b11000000,
					      8'b01100000,
					      8'b00111110
					      };
   
   assign pattern_table_3.pattern_bytes_1 = {8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111
					      };
   assign pattern_table_3.pattern_bytes_2 = {8'b00000000, //M
					      8'b11000110,
					      8'b11000110,
					      8'b11010110,
					      8'b11111110,
					      8'b11111110,
					      8'b11101110,
					      8'b00111000,
					      };

   assign pattern_table_4.pattern_bytes_1 = {8'b00000000, //E
					      8'b11111110,
					      8'b11000000,
					      8'b11000000,
					      8'b11111110,
					      8'b11000000,
					      8'b11000000,
					      8'b11111110
					      };
   assign pattern_table_4.pattern_bytes_2 = {8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111,
					      8'b11111111
					      };

   assign pattern_table_5.pattern_bytes_1 = {8'b1111_1111,
					      8'b1000_0001,
					      8'b1011_1101,
					      8'b1010_0101,
					      8'b1010_0101,
					      8'b1011_1101,
					      8'b1000_0001,
					      8'b1111_1111
					      };
   assign pattern_table_5.pattern_bytes_2 = {8'b0000_0000,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0000_0000
					      };

   assign pattern_table_6.pattern_bytes_1 = {8'b1111_1111,
					      8'b1111_1111,
					      8'b1111_1111,
					      8'b1111_1111,
					      8'b1111_1111,
					      8'b1111_1111,
					      8'b1111_1111,
					      8'b1111_1111
					      };
   assign pattern_table_6.pattern_bytes_2 = {8'b0000_0000,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0111_1110,
					      8'b0000_0000
					      };
   assign pattern_table_7.pattern_bytes_1 = pattern_table_6.pattern_bytes_1;
   assign pattern_table_7.pattern_bytes_2 = pattern_table_6.pattern_bytes_2;

   logic [3:0] 			sel;
   assign sel = 3'd0;
   
   always_ff @(negedge clock_in) begin
      if(reset_in) begin
	 data_out <= 0;
      end else begin
	 if(addr_in < NAMETABLE_LOWER_BOUND) begin
	    case (sel) //addr_in[6:4]) 
	      3'd0: begin
		 data_out <= addr_in[3] ?
			     pattern_table_0.pattern_bytes_2[addr_in[2:0]] :
			     pattern_table_0.pattern_bytes_1[addr_in[2:0]];
	      end
	      3'd1 : begin
	      data_out <= addr_in[3] ?
			  pattern_table_1.pattern_bytes_2[addr_in[2:0]] :
			  pattern_table_1.pattern_bytes_1[addr_in[2:0]];

	      end
	      3'd2:begin
		 data_out <= addr_in[3] ?
			     pattern_table_2.pattern_bytes_2[addr_in[2:0]] :
			     pattern_table_2.pattern_bytes_1[addr_in[2:0]];
	      end
	      3'd3:begin
		 data_out <= addr_in[3] ?
			     pattern_table_3.pattern_bytes_2[addr_in[2:0]] :
			     pattern_table_3.pattern_bytes_1[addr_in[2:0]];
	      end
	      3'd4:begin
		 data_out <= addr_in[3] ?
			     pattern_table_4.pattern_bytes_2[addr_in[2:0]] :
			     pattern_table_4.pattern_bytes_1[addr_in[2:0]];
	      end
	      3'd5:begin
		 data_out <= addr_in[3] ?
			     pattern_table_5.pattern_bytes_2[addr_in[2:0]] :
			     pattern_table_5.pattern_bytes_1[addr_in[2:0]];
	      end
	      3'd6:begin
		 data_out <= addr_in[3] ?
			     pattern_table_6.pattern_bytes_2[addr_in[2:0]] :
			     pattern_table_6.pattern_bytes_1[addr_in[2:0]];
	      end
	      3'd7:begin
		 data_out <= addr_in[3] ?
			     pattern_table_7.pattern_bytes_2[addr_in[2:0]] :
			     pattern_table_7.pattern_bytes_1[addr_in[2:0]];
	      end
	    endcase // case (addr_in[6:4])

	 end else if(NAMETABLE_LOWER_BOUND <= addr_in && addr_in < NAMETABLE_UPPER_BOUND) begin
	    //data_out <= NAMETABLE_BYTE_1;
	    case (addr_in[2:0])
	      3'd0 : data_out <= 2'h00;
	      3'd1 : data_out <= 2'h01;
	      3'd2 : data_out <= 2'h02;
	      3'd3 : data_out <= 2'h03;
	      3'd4 : data_out <= 2'h04;
	      default : data_out <= 2'h00;
	    endcase // case (addr_in[2:0])
	    
	 end else if(ATTRIBUTE_LOWER_BOUND <= addr_in && addr_in < ATTRIBUTE_UPPER_BOUND) begin
	    data_out <= ATTRIBUTE_BYTE;

	 end else begin
	    data_out <= DEFAULT_BYTE;
	 end
      end
   end
endmodule
