/* 
* this should hide all VGA data. (i think)
* expose simple API to write to some arbitrary memory 
* and that's what get's written to the screen
*
* need to figure out how to sync
*/
module vga(
        input logic 	   clk50,
	input logic 	   reset,
	input logic [5:0]  ppu_data,
	input logic [7:0]  ppu_addr,
	input logic 	   vga_en, //toggle
	input logic 	   we, ppu_en,
	input logic [9:0]  hcount, vcount,

	output logic [7:0] VGA_R, VGA_G, VGA_B,
	output logic 	   VGA_CLK, VGA_HS, VGA_VS,
			   VGA_BLANK_n, VGA_SYNC_n);
   // brought in externally
   //logic [10:0]    hcount;
   //logic [9:0]     vcount;
   logic [8:0] 	   rdaddress, wraddress;
   logic [7:0] 	   data, background_r, background_g, background_b;
   logic [5:0] 	   buff_out;
   logic [4:0] 	   hmod, vmod;

   assign hmod = hcount % 5'd16;
   assign vmod = vcount % 5'd16;
   
   scan_buff buff( .data(data), .rdaddress(rdaddress), .rdclock(vga_en),
		   .rdclocken(vga_en), .wraddress(wraddress), .wrclock(ppu_en),
		   .wrclocken(ppu_en), .wren(we), .q(buff_out) );

   vga_counters counters(.clk50(clk50), .*);
   ppu_vga_lut lut(.ppu_in(buff_out), .r(background_r), .g(background_g), 
		   .b(background_b));
   assign wraddress[8] = vcount[2]; //toggle;
   assign wraddress[7:0] = ppu_addr;
   assign rdaddress[8] = ~vcount[2]; //~toggle;
   assign rdaddress[7:0] = hcount[8:1];
   assign data[5:0] = ppu_data;
   assign data[7:6] = 2'b00;
   
   always_comb begin
      {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
      if (VGA_BLANK_n )
	/*if ( hmod < 5'd1 )
	  {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h00, 8'h00};
	else if ( vmod < 5'd1 )
	  {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h00, 8'h00};
      	else */
	{VGA_R, VGA_G, VGA_B} =
				 {background_r, background_g, background_b};
   end
	       
endmodule

module vga_counters(
 input logic 	     clk50, reset, vga_en,
 input logic [9:0] hcount,  // hcount[10:1] is pixel column
 input logic [9:0] vcount,  // vcount[9:0] is pixel row
 output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 10'd 512,
             HFRONT_PORCH = 10'd 16,
             HSYNC        = 10'd 96,
             HBACK_PORCH  = 10'd 58,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 682
   
    assign VGA_CLK = vga_en;

   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 32,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 524
   /*
    * Commented out because hcount is now generated externally
    * this whole module can easily be absorbed by vga_module
    * 
   logic endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;
       
   logic endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1; */

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   //assign VGA_HS = !( (hcount[9:7] == 3'b101) &
		      //!(hcount[6:4] == 3'b111));
   //assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_HS = !( hcount > (HACTIVE + HFRONT_PORCH - 1) && hcount < (HTOTAL - HBACK_PORCH + 1) );
   assign VGA_VS = !( vcount == 491 || vcount == 492 );

   assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   //assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
   assign VGA_BLANK_n = !( hcount[9] ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   //assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
   //always_ff @(posedge clk50)
   //  if (reset) VGA_CLK =0;
   //  else if (vga_en) VGA_CLK = ~VGA_CLK;
   
endmodule
