/*
 * Userspace program that communicates with the ultranes device driver
 * through ioctls
 *
 * Zach Schuermann
 * Columbia University
 */

#include <stdio.h>
#include "ultranes.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

/* send */
int send(int fd, int v, int a) {
  ultranes_arg_t vla;
  vla.v = v; 
  vla.addr = a; 
  if (ioctl(fd, ULTRANES_SEND, &vla)) {
      perror("ioctl(ULTRANES_SEND) failed");
      return -1;
  }
  return 0;
}

/* Read address */
int get_addr(int fd) {
  ultranes_arg_t vla;
  
  if (ioctl(fd, ULTRANES_READ_ADDR, &vla)) {
      perror("ioctl(ULTRANES_READ_ADDR) failed");
      return -1;
  }
  //printf("$%x\n", vla.addr);
  return vla.addr;
}
