// CSEE 4840 
//
// Spring 2020
//
// By: Zach Schuermann
// Uni: zvs2002

module ultranes(input   logic   clk50,
				input  	logic   reset,
                input   logic   [7:0] writedata,
                input   logic   write,
                input           chipselect,
                input   logic   [16:0] address,
                input   logic   [3:0] KEY,

                output  logic   [7:0] VGA_R, VGA_G, VGA_B,
                output  logic   VGA_CLK, VGA_HS, VGA_VS, 
                output  logic   VGA_BLANK_n, VGA_SYNC_n,

				output  logic   [9:0] LEDR,
				output  logic   [7:0] readdata
             );

    logic rst;
    logic sw_rst;
    logic [15:0] addr;
    logic [15:0] addr2;
    logic [7:0] DI;
    logic [7:0] DO;
	logic WE;
    logic [7:0] DI2;
    logic [7:0] DO2;
	logic WE2;

    assign WE2 = write;
	logic cpu_ce = 1'b0;  // CPU CE

    assign LEDR[0] = rst|sw_rst;
    assign LEDR[1] = cpu_ce;
    assign LEDR[2] = WE;
    assign LEDR[3] = WE2;
    assign LEDR[7] = sw_rst;
    assign LEDR[9] = reset;

    // avalon bus to write to CPU RAM
    always_ff @(posedge clk50) begin
        if (reset) begin
            sw_rst <= 1'b0;
        end else if (chipselect && write) begin
            if ( address[16] & address[15] ) begin
                sw_rst <= writedata[0];
            end
            else begin
                addr2 <= address[15:0];
                DO2 <= writedata[7:0];
                //WE2 <= 1; // nvm, just set WE2 to be write
            end
        end else if (chipselect) begin
            if (address == 0)
                readdata <= addr[7:0];
            else if (address == 1)
                readdata <= addr[15:8];
        end
    end
    
    // generate cpu_ce
	logic[4:0] clkcount = 5'h0;
	always @(posedge clk50) begin
		if(clkcount == 5'd24)
            cpu_ce <= 1;
        else begin
            if(clkcount == 5'd25) begin
			    clkcount <= 5'd0;
                cpu_ce <= 0;
		    end
		    else
			    clkcount <= clkcount + 5'd1;
        end
	end

    // switch bounce for hardware reset key
    logic [21:0] counter;
    always_ff @(posedge clk50) begin
        // catch wait for release
        if (~rst & (counter == 0))
            begin
            // detect press
            if (~KEY[0])
                begin
                    rst <= 1'b1;
                end
            end // if (~down)
        else if (KEY[0]) begin
            rst <= 1'b0;
    	    end
        counter <= (counter>=2000000)?0:counter+1;
    end

    ///////////////
    // CPU + RAM //
    ///////////////

	dpram ram (
	    .clk1(clk50),
	    .data_a(DO),
	    .data_b(DO2),
	    .addr_a(addr),
	    .addr_b(addr2),
	    .we_a(WE),
	    .we_b(WE2),
	    .q_a(DI),
	    .q_b(DI2),
	);
    	
	cpu cpu0 (clk50, cpu_ce, rst|sw_rst, addr, DI, DO, WE, 1'b0, 1'b0, 1'b1 );  

    ///////////////
    //    PPU    //
    ///////////////
    
    logic [8:0] 			   ppu_hcount; //0 - 340
    logic [8:0] 			   ppu_vcount; //0 - 261
    logic [9:0] 		           hcount;
    logic [9:0] 			   vcount;
    logic 			           ppu_en;
    logic [5:0] 			   ppu_data;
   

    ppu ppu0(.*);

    ///////////////
    //    VGA    //
    ///////////////
    
    logic 			           vga_en, we;

    vga vga0(.clk50(clk50),
             .reset(reset),
             .ppu_data(ppu_data),
	     .ppu_addr(ppu_hcount[7:0]),
             //.toggle(ppu_vcount[0]),
	     .vga_en(vga_en),
             .we(we),
             .ppu_en(ppu_en),
             .*);
  
    // do clock enable signals
    logic [3:0]	   counter_ppu;
    always_ff @(posedge clk50) begin
        if (reset) begin
	        counter_ppu <= 3'd0;
	        vga_en = 1'b0;
	        ppu_en = 1'b0;
        end else begin
            if (counter_ppu == 7) begin
                counter_ppu <= 0;
                ppu_en <= 1'b1;
            end else begin
	       ppu_en <= 1'b0;
               counter_ppu <= counter_ppu + 1;
            end
            vga_en <= ~vga_en;
        end // else: !if(reset)
    end // always_ff @

    always_ff @(posedge clk50) begin
        if (reset)
	        we = 1'b0;
        else begin
	        if (ppu_en) begin
	            if (ppu_hcount > 9'd255)
	                we <= 0;
	            else
	                we <= 1;
	        end
        end
    end // always_ff @

endmodule
