#include <iostream>
#include "verilated.h"
#include <verilated_vcd_c.h>
#include "Vcpu_test.h"

void traceTest() {
	Vcpu_test* cpu = new Vcpu_test;

	Verilated::traceEverOn(true);
	VerilatedVcdC* tfp = new VerilatedVcdC;
	cpu->trace(tfp, 99);
	tfp->open("cpusim.vcd");

	for (int time = 0; time < 10000000; time++) {
		//if (time == 0) cpu->reset = 1;
		//if (time == 1000) cpu->reset = 0;
		//if (time == 10000) cpu->reset = 1;
		//if (time == 10005) cpu->reset = 0;
		cpu->clk50 = (time & 2) ? 1 : 0;
		cpu->eval();

        if (time % 1000000 == 0) std::cout << std::hex << cpu->aout << std::endl;
		tfp->dump(time);
	}

	tfp->close();
	delete tfp;

	cpu->final();
	delete cpu;
}

void test() {
	Vcpu_test* cpu = new Vcpu_test;

	//while (!Verilated::gotFinish()) { top->eval(); }
	for (int time = 0; true; time++) {
		if (time == 0) cpu->reset = 1;
		if (time == 1000) cpu->reset = 0;
		//if (time == 10000) cpu->reset = 1;
		//if (time == 10005) cpu->reset = 0;
		cpu->clk50 = (time & 2) ? 1 : 0;
		cpu->eval();

        if (time % 100000000 == 0) std::cout << std::hex << cpu->aout << std::endl;
	}

	cpu->final();
	delete cpu;
}

int main(int argc, const char** argv, const char** env) {
	Verilated::commandArgs(argc, argv);
    //test();
    traceTest();
	exit(0);
}
