// CSEE 4840 
//
// Spring 2020
//
// By: Zach Schuermann
// Uni: zvs2002

module cpu_test(input     logic clk50,
				input  	logic reset,
                //input logic KEY,
				//output logic LEDR,
				output logic [15:0] aout
             );

	//reg reset = 1;
    logic rst = 1;
   logic [15:0] addr;
	assign aout = addr;
   logic [7:0] DI;
   logic [7:0] DO;
	logic WE;
	reg [7:0] ram[65535:0];
				 
    logic [16:0] counter = 17'h0;
    logic cpu_ce = 1'b0;
    /*
	logic[4:0] clkcount = 5'h0;
	logic clk = 1'b0;                  // 1 MHz clock
	always @(posedge clk50) begin   // 50 MHz clock 
		if(clkcount == 5'd24) begin     // Every 25 cycles,
			clkcount <= 5'd0;            // Reset the counter
			//clk <= ~clk;                 // And toggle the clock
		end
		else
			clkcount <= clkcount + 5'd1;
	end*/
	

	logic[4:0] clkcount = 5'h0;
	always @(posedge clk50) begin       // 50 MHz clock 
		if(clkcount == 5'd24) begin     // Every 25 cycles,
			//clkcount <= 5'd0;           // Reset the counter
			//clk <= ~clk;                // And toggle the clock
            cpu_ce <= 1;
		end
        else begin
            if(clkcount == 5'd25) begin     // Every 25 cycles,
			    clkcount <= 5'd0;           // Reset the counter
			    //clk <= ~clk;                // And toggle the clock
                cpu_ce <= 0;
		    end
		    else
			    clkcount <= clkcount + 5'd1;
        end
	end

	always @(posedge clk50) begin
		if (WE) begin
			ram[addr] <= DO;
			DI <= DO;
		end
		else begin
			DI <= ram[addr];
		end
	end

	always @(posedge clk50) begin
        if (counter[16]) begin
            rst <= 0;
        end
        counter <= counter + 1;
	end

   //logic [21:0] counter;
   //always_ff @(posedge clk50) begin
   //   // catch wait for release
   //   if (~reset & (counter == 0))
   //     begin
   //        // detect press
   //        if (~KEY)
   //          begin
   //             reset <= 1'b1;
   // 			LEDR <= 1'b1;
   //          end
   //     end // if (~down)
   //   else if (KEY) begin
   //     reset <= 1'b0;
   // 	LEDR <= 1'b1;
   // 	end
   //   counter <= (counter>=2000000)?0:counter+1;
   //end

	
	//initial $readmemh("bin/test.hex", ram);
	initial $readmemh("bin/dk-cpu-test.hex", ram);
				 
	cpu testcpu (clk50, cpu_ce, rst, addr, DI, DO, WE, 1'b0, 1'b0, 1'b1 );  

endmodule



/*
module controller(input logic        clk,
                  input logic [3:0]  KEY,
                  input logic [7:0]  dout,
                  output logic [3:0] a,
                  output logic [7:0] din,
                  output logic       we);

   logic [3:0]  addr;
   logic [21:0] counter;
   logic        down;
  
   always_ff @(posedge clk) begin
      // catch wait for release
      if (~down & (counter == 0))
        begin
           // detect press
           if (~KEY[0])
             begin
                down <= 1'b1;
                we <= 1'b0;
                addr <= addr + 4'd1;
             end
           else if (~KEY[1])
             begin
                down <= 1'b1;
                we <= 1'b0;
                addr <= addr - 4'd1;
             end
           else if (~KEY[2])
             begin
                down <= 1'b1;
                din <= dout + 4'd1;
                we <= 1'b1;
             end
           else if (~KEY[3])
             begin
                down <= 1'b1;
                din <= dout - 4'd1;
                we <= 1'b1;
             end
        end // if (~down)
      else if (KEY[0] & KEY[1] & KEY[2] & KEY[3])
        down <= 1'b0;
      a <= addr;
      counter <= (counter>=2000000)?0:counter+1;
   end

endmodule

module hex7seg(input logic [3:0] a,
               output logic [6:0] y);

   always_comb
     case (a)
       4'd0:    y = 7'b100_0000;
       4'd1:    y = 7'b111_1001;
       4'd2:    y = 7'b010_0100;
       4'd3:    y = 7'b011_0000;
       4'd4:    y = 7'b001_1001;
       4'd5:    y = 7'b001_0010;
       4'd6:    y = 7'b000_0010;
       4'd7:    y = 7'b111_1000;
       4'd8:    y = 7'b000_0000;
       4'd9:    y = 7'b001_1000;
       4'd10:   y = 7'b000_1000;
       4'd11:   y = 7'b000_0011;
       4'd12:   y = 7'b100_0110;
       4'd13:   y = 7'b010_0001;
       4'd14:   y = 7'b000_0110;
       4'd15:   y = 7'b000_1110;
       default: y = 7'b000_0000;
     endcase // case (a)
endmodule

// 16 X 8 synchronous RAM with old data read-during-write behavior
module memory(input logic        clk,
              input logic [3:0]  a,
              input logic [7:0]  din,
              input logic        we,
              output logic [7:0] dout);
  
   logic [7:0] mem [15:0];

   always_ff @(posedge clk) begin
      if (we) mem[a] <= din;
      dout <= mem[a];
   end
        
endmodule
*/
