// From Quartus Prime Verilog Template
// 'True Dual Port RAM with single clock'
module dpram
#(parameter DATA_WIDTH=8, parameter ADDR_WIDTH=16)
(
	input [(DATA_WIDTH-1):0] data_a, data_b,
	input [(ADDR_WIDTH-1):0] addr_a, addr_b,
	input we_a, we_b, clk1,
	output reg [(DATA_WIDTH-1):0] q_a, q_b
);
   reg [DATA_WIDTH-1:0] 	      mem[2**ADDR_WIDTH-1:0];
   //initial $readmemh("bin/test.hex", mem);
   initial $readmemh("bin/vtest.hex", mem);
   
   

	// Port A 
	always @ (posedge clk1)
	begin
		if (we_a) 
		begin
			mem[addr_a] <= data_a;
			q_a <= data_a;
		end
		else 
		begin
			q_a <= mem[addr_a];
		end 
	end 

	// Port B 
	always @ (posedge clk1)
	begin
		if (we_b) 
		begin
			mem[addr_b] <= data_b;
			q_b <= data_b;
		end
		else 
		begin
			q_b <= mem[addr_b];
		end 
	end

endmodule


// Quartus Prime Verilog Template
// True Dual Port RAM with dual clocks
module dpdc_ram
#(parameter DATA_WIDTH=8, parameter ADDR_WIDTH=9)
(
	input [(DATA_WIDTH-1):0] data_a, data_b,
	input [(ADDR_WIDTH-1):0] addr_a, addr_b,
	input we_a, we_b, clk_a, clk_b,
	output reg [(DATA_WIDTH-1):0] q_a, q_b
);

	// Declare the RAM variable
	reg [DATA_WIDTH-1:0] ram[2**ADDR_WIDTH-1:0];
	//initial $readmemh("bin/vga.hex", ram);

	always @ (posedge clk_a)
	begin
		// Port A 
		if (we_a) 
		begin
			ram[addr_a] <= data_a;
			q_a <= data_a;
		end
		else 
		begin
			q_a <= ram[addr_a];
		end 
	end

	always @ (posedge clk_b)
	begin
		// Port B 
		if (we_b) 
		begin
			ram[addr_b] <= data_b;
			q_b <= data_b;
		end
		else 
		begin
			q_b <= ram[addr_b];
		end 
	end

endmodule
