ultraNES
========

NES Emulator implemented on DE1-SoC. Using 6502 verilog implementation + PPU +
controller. (sound TBD)
Main contribution is PPU; this thing has to run Zelda.

[Tracking issue](/../../issues/1)

## Development
To build/flash, first make the `rbf` and `dtb` files with `make`, then install
the `rbf` with `make flash` and install the `dtb`  with `make dtb_install`
(these require a valid ssh target named `fpga` in `.ssh/config` to scp files to the board).
Reboot and run userspace code, etc. When you reprogram in the future (as long as
the interface to the SOC doesn't change), you will only have to `make` and `make
flash` since the `dtb` will remain the same.

## FPGA-land
Once the FPGA is running with the correct configuration, you can ssh (or screen)
into Linux running on the SoC and use the device driver + userspace program to
interact with the ultraNES implementation.  
Install (after cloning this repo) with:
``` sh
$ ./install.sh
$ ultranes -h
```

### Usage Examples

``` sh
$ ultranes                          # print current value on address bus
$ ultranes reset 1                  # set CPU reset high
$ ultranes reset 0                  # set CPU reset low
$ ultranes load cpu bin/test.hex    # load test.hex ROM into CPU RAM
$ ultranes load dk bin/dk.nes       # load dk.nes ROM into CPU+PPU RAM
$ ultranes load mario bin/mario.nes # load mario.nes ROM into CPU+PPU RAM
$ ultranes write 55 128             # write value 55 to address 128
$ ultranes help                     # call in backup
```

To rebuild the executable, use: 
``` sh
$ pushd user; cargo build --release && popd
$ cp user/target/release/ultranes bin/ 
```

### Organization
- The root `Makefile` builds the hardware with quartus, etc.
- `driver/` includes the Linux device driver (kernel module)
- `user/` includes the userspace program (implemented in Rust)
- `test/` includes 6502 testing simulation. You can run a simulation of the
  6502 test using verilator.
- `bin/` includes the binaries for 6502 regression tests and a precompiled
  binary of the userspace program. 

### Ref
[c64 on fpga][c64_on_fpga]  
[6502 functional tests][6502_func_test]

[c64_on_fpga]: http://c64onfpga.blogspot.com/2017/11/running-on-fpga.html
[6502_func_test]: https://github.com/Klaus2m5/6502_65C02_functional_tests
