# Towers of Hanoi solution in MIPS assembly

# $a0 is src
# $a1 is tmp
# $a2 is dst
# $a3 is n

	.data
arrow:	.asciiz "->"
newline: .asciiz "\n"
	.text
	
	.globl hmove
hmove:
	addiu $sp, $sp, -24 # space for $ra, $s0-$s3
	beq $a3, $0, L1 # n == 0?
	sw  $ra, 0($sp)
	sw  $s0, 4($sp)
	sw  $s1, 8($sp)
	sw  $s2, 12($sp)
	sw  $s3, 16($sp)

	move $s0, $a0      # src
	move $s1, $a1      # tmp
	move $s2, $a2      # dst
	addiu $s3, $a3, -1 # n - 1

	move $a1, $s2  # dst
	move $a2, $s1  # tmp
	move $a3, $s3  # n - 1
	jal hmove

	li $v0, 1      # print_int
	move $a0, $s0  # src
	syscall

	li $v0,4       # print_string
	la $a0, arrow
	syscall
	
	li $v0, 1      # print_int
	move $a0, $s2  # dst
	syscall

	li $v0,4       # print_string
	la $a0, newline
	syscall

	move $a0, $s1  # tmp
	move $a1, $s0  # src
	move $a2, $s2  # dst
	move $a3, $s3  # n - 1
	jal hmove

	lw  $ra, 0($sp)
	lw  $s0, 4($sp)
	lw  $s1, 8($sp)
	lw  $s2, 12($sp)
	lw  $s3, 16($sp)
	
L1:
	addiu $sp, $sp, 24 # release stack
	jr $ra

	.globl main
main:
  	move $s0, $ra
	li $a0, 1 # src
	li $a1, 2 # tmp
	li $a2, 3 # dst
	li $a3, 3
	jal hmove
  
	jr $s0
