{-
param1 : input file to match regex on
param2 : regex to match words agaainst
return :  list of number of matches per line

$ ghc -O2 runRegex.hs -rtsopts -eventlog
$ ./runRegex sample_in.txt at
[1, 1]

sample_in.txt:
phosphatize Kristian pre-expound Kourou Asshur conquistadores Mayview Turkey-carpeted
Blessington xanthochroia cue Lamb basso-relievo diarize esthesioblast Natica


Regex that we support:
abc*        matches a string that has ab followed by zero or more c
a(bc)*      matches a string that has a followed by zero or more copies of the sequence bc
roar        matches any string that has the text roar in it
a(b|c)      matches a string that has a followed by b or c, multiple ors not supported
\d          matches a single character that is a digit
.           matches any character
-}

import Control.Parallel.Strategies
import System.Environment(getArgs)
import Regex

main :: IO ()
main = do
  [f, regex] <- getArgs
  file <- readFile f

  let line      = map words $ lines file
      sol       = map (runRegex regex) line
  putStrLn $ show $ map length sol
