module Tracer (Resolution, Color, Diffuse(Solid), Texture(Texture), TexturedObj, Light(AmbientL, PointL),Scene(Scene), Camera(Camera), rayTrace)
where
  import Maybes
  import RayMath
 
  type Color = (Double, Double, Double)

  data Diffuse = Solid Color
 
  {- specularity reflectiveCoef specCoef refractiveIndex-}
  data Texture = Texture Diffuse Double Int Double Double

  type TexturedObj = (RenderObj, Texture)

  type Intensity = (Double, Double, Double)
  
  data Light = PointL Point3D Intensity
              | AmbientL Intensity
  
  {- fixed at 0,0,0, the point3d is the point camera looks at, dim is view window size -}
  data Camera = Camera Point3D Dimension 

  data Scene = Scene Camera Color [TexturedObj] [Light]

  data Intersection = Intersection Double Ray TexturedObj

  type Image = Point2D -> Color

  intersectDist :: (Maybe Intersection) -> Double
  intersectDist Nothing = 0.0
  intersectDist (Just (Intersection d _ _)) = d

  intersectText :: (Maybe Intersection) -> Texture
  intersectText Nothing = Texture (Solid (0.0,0.0,0.0)) 0.0 0 0.0 0.0
  intersectText ( Just (Intersection _ _ (_,t))) = t

  intersectPnt :: (Maybe Intersection) -> Point3D
  intersectPnt Nothing = (0.0,0.0,0.0)
  intersectPnt ( Just (Intersection d (Ray start dir) _)) = start <+> (dir **> d)

  normalAt :: (Maybe Intersection) -> Vector
  normalAt Nothing = (0.0,0.0,0.0)
  normalAt i@(Just (Intersection _ _ (o, _ ))) = normal (intersectPnt i) o

  colorAt :: (Maybe Intersection) -> Color
  colorAt Nothing = (0.0,0.0,0.0)
  colorAt (Just (Intersection _ _ (_,Texture (Solid color) _ _ _ _)))= color

  {- closest intersection of a ray and an object, with distance > given -}
  closeInter :: Ray -> (Maybe Intersection) -> TexturedObj -> (Maybe Intersection)
  closeInter r i (o,m)
    | d > 10**(-6) && ((isNothing i) || d < (intersectDist i)) = Just (Intersection d r (o,m))
    | otherwise = i
    where
      d = firstPos (rayIntersectWith r o)
      firstPos [] = 0.0
      firstPos (x:xs)
        | x > 10**(-6) = x
        | otherwise = firstPos xs

  intersectList :: Ray -> [TexturedObj] -> (Maybe Intersection)
  intersectList r o = foldl (closeInter r) Nothing o

  {- diffuse color at intersection -}
  diff :: (Maybe Intersection) -> Light -> Color
  diff _ (AmbientL _) = (0.0,0.0,0.0)
  diff i (PointL pos int) = (int **> ((point2Vec (intersectPnt i) pos) `dot` (normalAt i))) <**> (colorAt i)
  
  {- specular color at intersection -}
  spec :: (Maybe Intersection) -> Vector -> Light -> Color
  spec _ _ (AmbientL _) = (0.0,0.0,0.0)
  spec i d (PointL p int) = int **> (rCoef * ( ((normalAt i) `dot` h)**(fromIntegral sCoef)))
    where
      h = norm ((d **> (-1)) <+> (point2Vec (intersectPnt i) p))
      (Texture _ rCoef sCoef _ _) = intersectText i
 
  shadePnt :: Intersection -> Vector -> [TexturedObj] -> Light -> Color
  shadePnt _ _ _ (AmbientL int) = int --direction doesn't matter
  shadePnt i d o l@(PointL pos _)
    | shadow = (0.0,0.0,0.0)
    | otherwise = (diff (Just i) l) <+> (spec (Just i) d l)
    where
      shadow = not (isNothing iShad) && (intersectDist iShad) <= dist (intersectPnt (Just i)) pos
      iShad = intersectList (instRay (intersectPnt (Just i)) pos) o

  reflectPnt :: Int -> Intersection -> Vector -> [TexturedObj] -> [Light] -> Color
  reflectPnt dep i d = colorPnt dep (Ray (intersectPnt (Just i)) (reflectDir d (normalAt (Just i)))) (0.0,0.0,0.0)

  refractPnt :: Int -> Intersection -> Vector -> Color -> [TexturedObj] -> [Light] -> Color
  refractPnt dep i d b
    | rDir == (0.0,0.0,0.0) = (\_ _ -> (0.0,0.0,0.0))
    | otherwise = colorPnt dep (Ray (intersectPnt (Just i)) rDir) (b **> rCoef)
    where
      rDir = refractDir d (normalAt (Just i)) rInd
      (Texture _ _ _ rCoef rInd) = intersectText (Just i)
  
  {- color in a point using all the color info -}
  colorPnt :: Int -> Ray -> Color -> [TexturedObj] -> [Light] -> Color
  colorPnt (-1) _ _ _ _ = (0.0,0.0,0.0)
  colorPnt d r@(Ray _ dir) b objs l
    | isNothing i = b
    | otherwise = colorClip $ shadeCol <+> refCol <+> refrCol
    where
      shadeCol = foldl (<+>) (0.0,0.0,0.0) (map (shadePnt (fromJust i) dir objs) l)
      refCol
        | refCoef == 0.0 = (0.0,0.0,0.0)
        | otherwise = (reflectPnt (d-1) (fromJust i) dir objs l )**>refCoef
      refrCol
        | refrCoef == 0.0 = (0.0,0.0,0.0)
        | otherwise = (refractPnt (d-1) (fromJust i) dir b objs l)**>refrCoef
      i = intersectList r objs
      (Texture _ refCoef _ refrCoef _) = intersectText i

  rayTracePnt :: Int -> Scene -> Point3D -> Color
  rayTracePnt d (Scene (Camera lens _) a b c) p = colorPnt d (Ray p (point2Vec lens p)) a b c

  {-finally trace the scene, return list of colors repping the image-}
  rayTrace :: Int -> Resolution -> Scene -> Image
  rayTrace d r s@(Scene (Camera _ dim) _ _ _) = (rayTracePnt d s) . (resToWin r dim)
