module TraceOutput (getTime, createImage, getImage) where
  import Tracer (Resolution, Color, Scene, rayTrace)
  import System.IO (writeFile)
  import Control.Parallel.Strategies (withStrategy, parBuffer, rdeepseq)
  import GHC.Conc (numCapabilities)
  import Data.List.Split (chunksOf)

  getTime :: Integer -> Integer -> String
  getTime before after = show $ after - before
  
  {- returns a color array representing the image -}
  getImage :: Int -> Resolution -> Scene -> [Color]
  getImage d r@(rx,ry) s = concat $ withStrategy (parBuffer n rdeepseq) (map imagec $ chunks [(fromIntegral x, fromIntegral (-y)) | y<- [-(ry-1)..0], x <- [0..(rx-1)]])
    where
      imagec x=  map (rayTrace d r s) x
      n = numCapabilities
      chunks x = chunksOf 512 x

  
  {- makes a ppm file, easiest to make without librairies -}
  createImage :: Resolution -> [Color] -> String -> IO()
  createImage (w,h) colors name = do
      writeFile name str
        where
          str = ("P3\n"++) . shows w . (' ':) . shows h . ("\n255\n"++) . stringify colors $ ""
          stringify = flip $ foldr showC
          c = 255
          showC (r,g,b) = shows (round (r*c)::Integer) 
            . (' ':) . shows (round (g*c)::Integer) 
            . (' ':) . shows (round (b*c)::Integer) . (' ':)
      
