import TraceOutput (getTime, createImage, getImage)
import RenParse (RendDesc(RendDesc), readScene)
import System.Environment (getArgs)
import System.CPUTime (getCPUTime)
import System.Directory (doesFileExist)

main :: IO()
main = do
  args <- getArgs
  if (length args /= 2) then
    error("Usage: Trace <scene path> <image path (ppm)>\n")
    else 
      do 
        let input = head args
        let output = head (tail args)
        exists <- doesFileExist input
        if (exists) 
          then  
            do content <- readFile input
               let (RendDesc res depth scene) = readScene content
               before <- getCPUTime
               createImage res (getImage depth res scene) output
               after <- getCPUTime
               putStr $ "Render Time: " ++ (getTime before after) ++ "\n"
          else error $ "File: \"" ++ input ++ " does not exist.\n"
