{-# OPTIONS_GHC -w #-}
module RenParse (RendDesc(RendDesc), readScene) where

import Tracer (Scene(Scene), Texture(Texture), Diffuse(Solid), TexturedObj, 
		   Light(AmbientL, PointL), Camera(Camera))
import RayMath (Dimension, Resolution, RenderObj(Sphere,Plane))
import Data.Char (isSpace, isAlpha, isDigit)
import qualified Data.Array as Happy_Data_Array
import qualified Data.Bits as Bits
import Control.Applicative(Applicative(..))
import Control.Monad (ap)



--scene which should be rendered
data RendDesc = RendDesc Resolution Int Scene


readScene:: String -> RendDesc
readScene= parseScene.lexer
-- parser produced by Happy Version 1.19.12

data HappyAbsSyn t4 t5 t6 t7 t8 t9 t10 t11 t12 t13 t14 t15
	= HappyTerminal (Token)
	| HappyErrorToken Int
	| HappyAbsSyn4 t4
	| HappyAbsSyn5 t5
	| HappyAbsSyn6 t6
	| HappyAbsSyn7 t7
	| HappyAbsSyn8 t8
	| HappyAbsSyn9 t9
	| HappyAbsSyn10 t10
	| HappyAbsSyn11 t11
	| HappyAbsSyn12 t12
	| HappyAbsSyn13 t13
	| HappyAbsSyn14 t14
	| HappyAbsSyn15 t15

happyExpList :: Happy_Data_Array.Array Int Int
happyExpList = Happy_Data_Array.listArray (0,146) ([0,32768,0,0,128,0,0,4,0,0,32768,0,0,0,64,0,0,4,0,4096,0,8192,0,128,0,0,0,64,0,8192,0,0,1,512,0,0,0,0,128,0,0,0,8,0,512,0,0,4,256,0,0,0,1,0,2048,0,0,0,1024,0,0,0,64,256,0,0,0,2,0,1024,0,1,0,0,256,0,0,64,256,0,0,512,0,0,16384,0,1,0,0,0,0,0,8,0,1024,0,0,6,0,16384,0,1,0,0,0,0,0,1,0,1,32768,0,0,0,16384,0,0,4,0,16,0,0,8,0,0,0,0,0,49152,0,32768,0,0,0,2048,0,0,8,256,0,0,0,4,0,1536,0,0,0,0,0,0,3072,0,256,0,0,0,4,0,1024,0,0,0,0,2048,0,32,0,256,0,0,0,64,0,1024,0,0,4,256,0,0,1,0,256,0,0,0,64,0,1024,0,0,0,2048,0,0,1,0,0,16384,0,0,64,0,16384,0,1,0,256,0,0,1,0,0,16384,0,16,0,0,2048,0,0,4,256,0,0,0,64,0,16384,0,0,64,256,0,0,1,0,256,0,0,0,8,256,0,0,1,0,128,0,0,0,64,0,0,0,0,8,0,2048,0,0,8,0,2048,0,0,4,0,0,0,1,0,256,0,0,1,0,0,16384,0,1,0,0,0,0,0,64,256,0,0,0,8,0,0,0,0,8,256,0,0,0,64,0,0,0,1,0,0,2048,0,0,8,0,0,0
	])

{-# NOINLINE happyExpListPerState #-}
happyExpListPerState st =
    token_strs_expected
  where token_strs = ["error","%dummy","%start_parseScene","RendDesc","Resolution","Scene","Camera","Background","Obj","Diffuse","Texture","TexturedObj","Objs","Light","Lights","int","double","camera","background","diffuse","solid","texture","sphere","plane","obj","objs","pointL","ambientL","lights","scene","resolution","rendDesc","'{'","'}'","'('","')'","'['","']'","','","%eof"]
        bit_start = st * 40
        bit_end = (st + 1) * 40
        read_bit = readArrayBit happyExpList
        bits = map read_bit [bit_start..bit_end - 1]
        bits_indexed = zip bits [0..39]
        token_strs_expected = concatMap f bits_indexed
        f (False, _) = []
        f (True, nr) = [token_strs !! nr]

action_0 (32) = happyShift action_2
action_0 (4) = happyGoto action_3
action_0 _ = happyFail (happyExpListPerState 0)

action_1 (32) = happyShift action_2
action_1 _ = happyFail (happyExpListPerState 1)

action_2 (35) = happyShift action_5
action_2 (5) = happyGoto action_4
action_2 _ = happyFail (happyExpListPerState 2)

action_3 (40) = happyAccept
action_3 _ = happyFail (happyExpListPerState 3)

action_4 (16) = happyShift action_7
action_4 _ = happyFail (happyExpListPerState 4)

action_5 (31) = happyShift action_6
action_5 _ = happyFail (happyExpListPerState 5)

action_6 (35) = happyShift action_9
action_6 _ = happyFail (happyExpListPerState 6)

action_7 (37) = happyShift action_8
action_7 _ = happyFail (happyExpListPerState 7)

action_8 (30) = happyShift action_12
action_8 (6) = happyGoto action_11
action_8 _ = happyFail (happyExpListPerState 8)

action_9 (16) = happyShift action_10
action_9 _ = happyFail (happyExpListPerState 9)

action_10 (39) = happyShift action_15
action_10 _ = happyFail (happyExpListPerState 10)

action_11 (38) = happyShift action_14
action_11 _ = happyFail (happyExpListPerState 11)

action_12 (33) = happyShift action_13
action_12 _ = happyFail (happyExpListPerState 12)

action_13 (18) = happyShift action_18
action_13 (7) = happyGoto action_17
action_13 _ = happyFail (happyExpListPerState 13)

action_14 _ = happyReduce_1

action_15 (16) = happyShift action_16
action_15 _ = happyFail (happyExpListPerState 15)

action_16 (36) = happyShift action_21
action_16 _ = happyFail (happyExpListPerState 16)

action_17 (34) = happyShift action_20
action_17 _ = happyFail (happyExpListPerState 17)

action_18 (35) = happyShift action_19
action_18 _ = happyFail (happyExpListPerState 18)

action_19 (17) = happyShift action_24
action_19 _ = happyFail (happyExpListPerState 19)

action_20 (33) = happyShift action_23
action_20 _ = happyFail (happyExpListPerState 20)

action_21 (36) = happyShift action_22
action_21 _ = happyFail (happyExpListPerState 21)

action_22 _ = happyReduce_2

action_23 (19) = happyShift action_27
action_23 (8) = happyGoto action_26
action_23 _ = happyFail (happyExpListPerState 23)

action_24 (39) = happyShift action_25
action_24 _ = happyFail (happyExpListPerState 24)

action_25 (17) = happyShift action_30
action_25 _ = happyFail (happyExpListPerState 25)

action_26 (34) = happyShift action_29
action_26 _ = happyFail (happyExpListPerState 26)

action_27 (35) = happyShift action_28
action_27 _ = happyFail (happyExpListPerState 27)

action_28 (17) = happyShift action_33
action_28 _ = happyFail (happyExpListPerState 28)

action_29 (33) = happyShift action_32
action_29 _ = happyFail (happyExpListPerState 29)

action_30 (39) = happyShift action_31
action_30 _ = happyFail (happyExpListPerState 30)

action_31 (17) = happyShift action_36
action_31 _ = happyFail (happyExpListPerState 31)

action_32 (26) = happyShift action_35
action_32 _ = happyFail (happyExpListPerState 32)

action_33 (39) = happyShift action_34
action_33 _ = happyFail (happyExpListPerState 33)

action_34 (17) = happyShift action_39
action_34 _ = happyFail (happyExpListPerState 34)

action_35 (13) = happyGoto action_38
action_35 _ = happyReduce_11

action_36 (36) = happyShift action_37
action_36 _ = happyFail (happyExpListPerState 36)

action_37 (35) = happyShift action_44
action_37 _ = happyFail (happyExpListPerState 37)

action_38 (34) = happyShift action_42
action_38 (35) = happyShift action_43
action_38 (12) = happyGoto action_41
action_38 _ = happyFail (happyExpListPerState 38)

action_39 (39) = happyShift action_40
action_39 _ = happyFail (happyExpListPerState 39)

action_40 (17) = happyShift action_48
action_40 _ = happyFail (happyExpListPerState 40)

action_41 _ = happyReduce_12

action_42 (33) = happyShift action_47
action_42 _ = happyFail (happyExpListPerState 42)

action_43 (25) = happyShift action_46
action_43 _ = happyFail (happyExpListPerState 43)

action_44 (16) = happyShift action_45
action_44 _ = happyFail (happyExpListPerState 44)

action_45 (39) = happyShift action_52
action_45 _ = happyFail (happyExpListPerState 45)

action_46 (35) = happyShift action_51
action_46 _ = happyFail (happyExpListPerState 46)

action_47 (29) = happyShift action_50
action_47 _ = happyFail (happyExpListPerState 47)

action_48 (36) = happyShift action_49
action_48 _ = happyFail (happyExpListPerState 48)

action_49 _ = happyReduce_5

action_50 (15) = happyGoto action_57
action_50 _ = happyReduce_15

action_51 (23) = happyShift action_55
action_51 (24) = happyShift action_56
action_51 (9) = happyGoto action_54
action_51 _ = happyFail (happyExpListPerState 51)

action_52 (16) = happyShift action_53
action_52 _ = happyFail (happyExpListPerState 52)

action_53 (36) = happyShift action_64
action_53 _ = happyFail (happyExpListPerState 53)

action_54 (36) = happyShift action_63
action_54 _ = happyFail (happyExpListPerState 54)

action_55 (17) = happyShift action_62
action_55 _ = happyFail (happyExpListPerState 55)

action_56 (35) = happyShift action_61
action_56 _ = happyFail (happyExpListPerState 56)

action_57 (34) = happyShift action_59
action_57 (35) = happyShift action_60
action_57 (14) = happyGoto action_58
action_57 _ = happyFail (happyExpListPerState 57)

action_58 _ = happyReduce_16

action_59 _ = happyReduce_3

action_60 (27) = happyShift action_69
action_60 (28) = happyShift action_70
action_60 _ = happyFail (happyExpListPerState 60)

action_61 (17) = happyShift action_68
action_61 _ = happyFail (happyExpListPerState 61)

action_62 (35) = happyShift action_67
action_62 _ = happyFail (happyExpListPerState 62)

action_63 (35) = happyShift action_66
action_63 (11) = happyGoto action_65
action_63 _ = happyFail (happyExpListPerState 63)

action_64 _ = happyReduce_4

action_65 (36) = happyShift action_76
action_65 _ = happyFail (happyExpListPerState 65)

action_66 (22) = happyShift action_75
action_66 _ = happyFail (happyExpListPerState 66)

action_67 (17) = happyShift action_74
action_67 _ = happyFail (happyExpListPerState 67)

action_68 (39) = happyShift action_73
action_68 _ = happyFail (happyExpListPerState 68)

action_69 (35) = happyShift action_72
action_69 _ = happyFail (happyExpListPerState 69)

action_70 (35) = happyShift action_71
action_70 _ = happyFail (happyExpListPerState 70)

action_71 (17) = happyShift action_81
action_71 _ = happyFail (happyExpListPerState 71)

action_72 (17) = happyShift action_80
action_72 _ = happyFail (happyExpListPerState 72)

action_73 (17) = happyShift action_79
action_73 _ = happyFail (happyExpListPerState 73)

action_74 (39) = happyShift action_78
action_74 _ = happyFail (happyExpListPerState 74)

action_75 (35) = happyShift action_77
action_75 _ = happyFail (happyExpListPerState 75)

action_76 _ = happyReduce_10

action_77 (20) = happyShift action_86
action_77 _ = happyFail (happyExpListPerState 77)

action_78 (17) = happyShift action_85
action_78 _ = happyFail (happyExpListPerState 78)

action_79 (39) = happyShift action_84
action_79 _ = happyFail (happyExpListPerState 79)

action_80 (39) = happyShift action_83
action_80 _ = happyFail (happyExpListPerState 80)

action_81 (39) = happyShift action_82
action_81 _ = happyFail (happyExpListPerState 81)

action_82 (17) = happyShift action_92
action_82 _ = happyFail (happyExpListPerState 82)

action_83 (17) = happyShift action_91
action_83 _ = happyFail (happyExpListPerState 83)

action_84 (17) = happyShift action_90
action_84 _ = happyFail (happyExpListPerState 84)

action_85 (39) = happyShift action_89
action_85 _ = happyFail (happyExpListPerState 85)

action_86 (21) = happyShift action_88
action_86 (10) = happyGoto action_87
action_86 _ = happyFail (happyExpListPerState 86)

action_87 (36) = happyShift action_98
action_87 _ = happyFail (happyExpListPerState 87)

action_88 (35) = happyShift action_97
action_88 _ = happyFail (happyExpListPerState 88)

action_89 (17) = happyShift action_96
action_89 _ = happyFail (happyExpListPerState 89)

action_90 (39) = happyShift action_95
action_90 _ = happyFail (happyExpListPerState 90)

action_91 (39) = happyShift action_94
action_91 _ = happyFail (happyExpListPerState 91)

action_92 (39) = happyShift action_93
action_92 _ = happyFail (happyExpListPerState 92)

action_93 (17) = happyShift action_104
action_93 _ = happyFail (happyExpListPerState 93)

action_94 (17) = happyShift action_103
action_94 _ = happyFail (happyExpListPerState 94)

action_95 (17) = happyShift action_102
action_95 _ = happyFail (happyExpListPerState 95)

action_96 (36) = happyShift action_101
action_96 _ = happyFail (happyExpListPerState 96)

action_97 (17) = happyShift action_100
action_97 _ = happyFail (happyExpListPerState 97)

action_98 (17) = happyShift action_99
action_98 _ = happyFail (happyExpListPerState 98)

action_99 (16) = happyShift action_109
action_99 _ = happyFail (happyExpListPerState 99)

action_100 (39) = happyShift action_108
action_100 _ = happyFail (happyExpListPerState 100)

action_101 _ = happyReduce_6

action_102 (36) = happyShift action_107
action_102 _ = happyFail (happyExpListPerState 102)

action_103 (36) = happyShift action_106
action_103 _ = happyFail (happyExpListPerState 103)

action_104 (36) = happyShift action_105
action_104 _ = happyFail (happyExpListPerState 104)

action_105 (36) = happyShift action_113
action_105 _ = happyFail (happyExpListPerState 105)

action_106 (35) = happyShift action_112
action_106 _ = happyFail (happyExpListPerState 106)

action_107 _ = happyReduce_7

action_108 (17) = happyShift action_111
action_108 _ = happyFail (happyExpListPerState 108)

action_109 (17) = happyShift action_110
action_109 _ = happyFail (happyExpListPerState 109)

action_110 (17) = happyShift action_116
action_110 _ = happyFail (happyExpListPerState 110)

action_111 (39) = happyShift action_115
action_111 _ = happyFail (happyExpListPerState 111)

action_112 (17) = happyShift action_114
action_112 _ = happyFail (happyExpListPerState 112)

action_113 _ = happyReduce_14

action_114 (39) = happyShift action_119
action_114 _ = happyFail (happyExpListPerState 114)

action_115 (17) = happyShift action_118
action_115 _ = happyFail (happyExpListPerState 115)

action_116 (36) = happyShift action_117
action_116 _ = happyFail (happyExpListPerState 116)

action_117 _ = happyReduce_9

action_118 (36) = happyShift action_121
action_118 _ = happyFail (happyExpListPerState 118)

action_119 (17) = happyShift action_120
action_119 _ = happyFail (happyExpListPerState 119)

action_120 (39) = happyShift action_122
action_120 _ = happyFail (happyExpListPerState 120)

action_121 _ = happyReduce_8

action_122 (17) = happyShift action_123
action_122 _ = happyFail (happyExpListPerState 122)

action_123 (36) = happyShift action_124
action_123 _ = happyFail (happyExpListPerState 123)

action_124 (36) = happyShift action_125
action_124 _ = happyFail (happyExpListPerState 124)

action_125 _ = happyReduce_13

happyReduce_1 = happyReduce 6 4 happyReduction_1
happyReduction_1 (_ `HappyStk`
	(HappyAbsSyn6  happy_var_5) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenInt happy_var_3)) `HappyStk`
	(HappyAbsSyn5  happy_var_2) `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn4
		 (RendDesc happy_var_2 happy_var_3 happy_var_5
	) `HappyStk` happyRest

happyReduce_2 = happyReduce 8 5 happyReduction_2
happyReduction_2 (_ `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenInt happy_var_6)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenInt happy_var_4)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn5
		 ((happy_var_4,happy_var_6)
	) `HappyStk` happyRest

happyReduce_3 = happyReduce 15 6 happyReduction_3
happyReduction_3 (_ `HappyStk`
	(HappyAbsSyn15  happy_var_14) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	(HappyAbsSyn13  happy_var_10) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	(HappyAbsSyn8  happy_var_6) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	(HappyAbsSyn7  happy_var_3) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn6
		 (Scene happy_var_3 happy_var_6 happy_var_10 happy_var_14
	) `HappyStk` happyRest

happyReduce_4 = happyReduce 13 7 happyReduction_4
happyReduction_4 (_ `HappyStk`
	(HappyTerminal (TokenInt happy_var_12)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenInt happy_var_10)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_7)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_5)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_3)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn7
		 (Camera (happy_var_3,happy_var_5,happy_var_7) (happy_var_10,happy_var_12)
	) `HappyStk` happyRest

happyReduce_5 = happyReduce 8 8 happyReduction_5
happyReduction_5 (_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_7)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_5)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_3)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn8
		 ((happy_var_3,happy_var_5,happy_var_7)
	) `HappyStk` happyRest

happyReduce_6 = happyReduce 9 9 happyReduction_6
happyReduction_6 (_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_8)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_6)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_4)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_2)) `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn9
		 (Sphere happy_var_2 (happy_var_4,happy_var_6,happy_var_8)
	) `HappyStk` happyRest

happyReduce_7 = happyReduce 10 9 happyReduction_7
happyReduction_7 (_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_9)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_7)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_5)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_3)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn9
		 (Plane (happy_var_3,happy_var_5,happy_var_7,happy_var_9)
	) `HappyStk` happyRest

happyReduce_8 = happyReduce 8 10 happyReduction_8
happyReduction_8 (_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_7)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_5)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_3)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn10
		 (Solid (happy_var_3,happy_var_5,happy_var_7)
	) `HappyStk` happyRest

happyReduce_9 = happyReduce 11 11 happyReduction_9
happyReduction_9 (_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_10)) `HappyStk`
	(HappyTerminal (TokenDouble happy_var_9)) `HappyStk`
	(HappyTerminal (TokenInt happy_var_8)) `HappyStk`
	(HappyTerminal (TokenDouble happy_var_7)) `HappyStk`
	_ `HappyStk`
	(HappyAbsSyn10  happy_var_5) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn11
		 (Texture happy_var_5 happy_var_7 happy_var_8 happy_var_9 happy_var_10
	) `HappyStk` happyRest

happyReduce_10 = happyReduce 7 12 happyReduction_10
happyReduction_10 (_ `HappyStk`
	(HappyAbsSyn11  happy_var_6) `HappyStk`
	_ `HappyStk`
	(HappyAbsSyn9  happy_var_4) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn12
		 ((happy_var_4,happy_var_6)
	) `HappyStk` happyRest

happyReduce_11 = happySpecReduce_0  13 happyReduction_11
happyReduction_11  =  HappyAbsSyn13
		 ([]
	)

happyReduce_12 = happySpecReduce_2  13 happyReduction_12
happyReduction_12 (HappyAbsSyn12  happy_var_2)
	(HappyAbsSyn13  happy_var_1)
	 =  HappyAbsSyn13
		 (happy_var_2 : happy_var_1
	)
happyReduction_12 _ _  = notHappyAtAll 

happyReduce_13 = happyReduce 17 14 happyReduction_13
happyReduction_13 (_ `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_15)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_13)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_11)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_8)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_6)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_4)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn14
		 (PointL (happy_var_4,happy_var_6,happy_var_8) (happy_var_11,happy_var_13,happy_var_15)
	) `HappyStk` happyRest

happyReduce_14 = happyReduce 10 14 happyReduction_14
happyReduction_14 (_ `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_8)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_6)) `HappyStk`
	_ `HappyStk`
	(HappyTerminal (TokenDouble happy_var_4)) `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	_ `HappyStk`
	happyRest)
	 = HappyAbsSyn14
		 (AmbientL (happy_var_4,happy_var_6,happy_var_8)
	) `HappyStk` happyRest

happyReduce_15 = happySpecReduce_0  15 happyReduction_15
happyReduction_15  =  HappyAbsSyn15
		 ([]
	)

happyReduce_16 = happySpecReduce_2  15 happyReduction_16
happyReduction_16 (HappyAbsSyn14  happy_var_2)
	(HappyAbsSyn15  happy_var_1)
	 =  HappyAbsSyn15
		 (happy_var_2 : happy_var_1
	)
happyReduction_16 _ _  = notHappyAtAll 

happyNewToken action sts stk [] =
	action 40 40 notHappyAtAll (HappyState action) sts stk []

happyNewToken action sts stk (tk:tks) =
	let cont i = action i i tk (HappyState action) sts stk tks in
	case tk of {
	TokenInt happy_dollar_dollar -> cont 16;
	TokenDouble happy_dollar_dollar -> cont 17;
	TokenCamera -> cont 18;
	TokenBackground -> cont 19;
	TokenDiffuse -> cont 20;
	TokenSolid -> cont 21;
	TokenTexture -> cont 22;
	TokenSphere -> cont 23;
	TokenPlane -> cont 24;
	TokenTexturedObj -> cont 25;
	TokenObjs -> cont 26;
	TokenPointL -> cont 27;
	TokenAmbientL -> cont 28;
	TokenLights -> cont 29;
	TokenScene -> cont 30;
	TokenResolution -> cont 31;
	TokenRendDesc -> cont 32;
	TokenOpenAcc -> cont 33;
	TokenCloseAcc -> cont 34;
	TokenOpenBrack -> cont 35;
	TokenCloseBrack -> cont 36;
	TokenOpenHook -> cont 37;
	TokenCloseHook -> cont 38;
	TokenComma -> cont 39;
	_ -> happyError' ((tk:tks), [])
	}

happyError_ explist 40 tk tks = happyError' (tks, explist)
happyError_ explist _ tk tks = happyError' ((tk:tks), explist)

newtype HappyIdentity a = HappyIdentity a
happyIdentity = HappyIdentity
happyRunIdentity (HappyIdentity a) = a

instance Functor HappyIdentity where
    fmap f (HappyIdentity a) = HappyIdentity (f a)

instance Applicative HappyIdentity where
    pure  = HappyIdentity
    (<*>) = ap
instance Monad HappyIdentity where
    return = pure
    (HappyIdentity p) >>= q = q p

happyThen :: () => HappyIdentity a -> (a -> HappyIdentity b) -> HappyIdentity b
happyThen = (>>=)
happyReturn :: () => a -> HappyIdentity a
happyReturn = (return)
happyThen1 m k tks = (>>=) m (\a -> k a tks)
happyReturn1 :: () => a -> b -> HappyIdentity a
happyReturn1 = \a tks -> (return) a
happyError' :: () => ([(Token)], [String]) -> HappyIdentity a
happyError' = HappyIdentity . (\(tokens, _) -> happyError tokens)
parseScene tks = happyRunIdentity happySomeParser where
 happySomeParser = happyThen (happyParse action_0 tks) (\x -> case x of {HappyAbsSyn4 z -> happyReturn z; _other -> notHappyAtAll })

happySeq = happyDontSeq


happyError :: [Token] -> a
happyError _ = error "Parse error ! ! !"

data Token
       = TokenInt Int
       | TokenDouble Double
       | TokenCamera
       | TokenBackground
       | TokenDiffuse
       | TokenSolid
       | TokenTexture
       | TokenSphere
       | TokenPlane
       | TokenObjType
       | TokenTexturedObj
       | TokenObjs
       | TokenPointL
       | TokenAmbientL
       | TokenLight
       | TokenLights
       | TokenScene
       | TokenResolution
       | TokenRendDesc
       | TokenOpenAcc
       | TokenCloseAcc
       | TokenOpenBrack
       | TokenCloseBrack
       | TokenOpenHook
       | TokenCloseHook
       | TokenComma

lexer :: String -> [Token]
lexer [] = []
lexer (c:cs) 
      | isSpace c = lexer cs
      | isAlpha c = lexVar (c:cs)
      | isDigit c = lexNum (c:cs) 1
lexer ('{':cs) = TokenOpenAcc : lexer cs
lexer ('}':cs) = TokenCloseAcc : lexer cs
lexer ('(':cs) = TokenOpenBrack : lexer cs
lexer (')':cs) = TokenCloseBrack : lexer cs
lexer ('[':cs) = TokenOpenHook : lexer cs
lexer (']':cs) = TokenCloseHook : lexer cs
lexer (',':cs) = TokenComma : lexer cs
lexer ('-':cs) = lexNum cs (-1)

lexNum cs mul
          | (r == '.')  = TokenDouble (mul * (read (num++[r]++num2) :: Double)) : lexer rest2
          | otherwise = TokenInt (round (mul * (read num))) : lexer (r:rest)
          where (num,(r:rest)) = span isDigit cs
	        (num2,rest2)   = span isDigit rest

lexVar cs =
   case span isAlpha cs of
      ("camera",rest)            -> TokenCamera : lexer rest
      ("background",rest)        -> TokenBackground : lexer rest
      ("diffuse",rest)           -> TokenDiffuse : lexer rest
      ("solid",rest)             -> TokenSolid : lexer rest
      ("texture",rest)           -> TokenTexture : lexer rest
      ("sphere",rest)            -> TokenSphere : lexer rest
      ("plane",rest)             -> TokenPlane : lexer rest
      ("obj",rest)            -> TokenTexturedObj : lexer rest
      ("objs",rest)           -> TokenObjs : lexer rest
      ("pointL",rest)        -> TokenPointL : lexer rest
      ("ambientL",rest)          -> TokenAmbientL : lexer rest
      ("light",rest)             -> TokenLight : lexer rest
      ("lights",rest)            -> TokenLights : lexer rest
      ("scene",rest)             -> TokenScene : lexer rest
      ("resolution",rest)        -> TokenResolution : lexer rest
      ("rendDesc",rest)          -> TokenRendDesc : lexer rest
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- $Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp $










































data Happy_IntList = HappyCons Int Happy_IntList








































infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is ERROR_TOK, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept (1) tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
         (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action









































indexShortOffAddr arr off = arr Happy_Data_Array.! off


{-# INLINE happyLt #-}
happyLt x y = (x < y)






readArrayBit arr bit =
    Bits.testBit (indexShortOffAddr arr (bit `div` 16)) (bit `mod` 16)






-----------------------------------------------------------------------------
-- HappyState data type (not arrays)



newtype HappyState b c = HappyState
        (Int ->                    -- token number
         Int ->                    -- token number (yes, again)
         b ->                           -- token semantic value
         HappyState b c ->              -- current state
         [HappyState b c] ->            -- state stack
         c)



-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state (1) tk st sts stk@(x `HappyStk` _) =
     let i = (case x of { HappyErrorToken (i) -> i }) in
--     trace "shifting the error token" $
     new_state i i tk (HappyState (new_state)) ((st):(sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state ((st):(sts)) ((HappyTerminal (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn (1) tk st sts stk
     = happyFail [] (1) tk st sts stk
happySpecReduce_0 nt fn j tk st@((HappyState (action))) sts stk
     = action nt j tk st ((st):(sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn (1) tk st sts stk
     = happyFail [] (1) tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@(((st@(HappyState (action))):(_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (action nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn (1) tk st sts stk
     = happyFail [] (1) tk st sts stk
happySpecReduce_2 nt fn j tk _ ((_):(sts@(((st@(HappyState (action))):(_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (action nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn (1) tk st sts stk
     = happyFail [] (1) tk st sts stk
happySpecReduce_3 nt fn j tk _ ((_):(((_):(sts@(((st@(HappyState (action))):(_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (action nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn (1) tk st sts stk
     = happyFail [] (1) tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k - ((1) :: Int)) sts of
         sts1@(((st1@(HappyState (action))):(_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (action nt j tk st1 sts1 r)

happyMonadReduce k nt fn (1) tk st sts stk
     = happyFail [] (1) tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k ((st):(sts)) of
        sts1@(((st1@(HappyState (action))):(_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> action nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn (1) tk st sts stk
     = happyFail [] (1) tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k ((st):(sts)) of
        sts1@(((st1@(HappyState (action))):(_))) ->
         let drop_stk = happyDropStk k stk





             _ = nt :: Int
             new_state = action

          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop (0) l = l
happyDrop n ((_):(t)) = happyDrop (n - ((1) :: Int)) t

happyDropStk (0) l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n - ((1)::Int)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction









happyGoto action j tk st = action j j tk (HappyState action)


-----------------------------------------------------------------------------
-- Error recovery (ERROR_TOK is the error token)

-- parse error if we are in recovery and we fail again
happyFail explist (1) tk old_st _ stk@(x `HappyStk` _) =
     let i = (case x of { HappyErrorToken (i) -> i }) in
--      trace "failing" $ 
        happyError_ explist i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  ERROR_TOK tk old_st CONS(HAPPYSTATE(action),sts) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        DO_ACTION(action,ERROR_TOK,tk,sts,(saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail explist i tk (HappyState (action)) sts stk =
--      trace "entering error recovery" $
        action (1) (1) tk (HappyState (action)) sts ((HappyErrorToken (i)) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions







-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.









{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
