import Evaluate (Execution(..),evaluate)
import System.Environment
import System.Exit(die)

main :: IO()
main = do
    args <- getArgs
    case args of
        [loadMode, buildTreeMode, queryMode, numPoint, numPolygon] -> do
            let lm = getMode loadMode
                tm = getMode buildTreeMode
                qm = getMode queryMode
                numPoint' = read numPoint :: Int
                numPolygon' = read numPolygon :: Int
            evaluate lm tm qm numPoint' numPolygon'
        _ -> do
            pn <- getProgName
            die $ "Usage: " ++ pn ++ " <loadFileMode> <makeTreeMode> "
                ++ "<queryPointMode> <numPoint> <numPolygon>\n"
                ++ "XMode: s --sequential, p --parallel"

getMode :: String -> Execution
getMode "s" = Sequential
getMode "p" = Parallel
getMode _ = error "Invalid mode"
