import           Perf
import           System.Environment
import           Display
import           Projection                     ( genPixels )
import           Scene                          ( fromPLY
                                                , projectScene
                                                )


main :: IO ()
main = do
  scene <- fromPLY "ply_files/helix.ply"
                   ((-1000), (-1000), 500)
                   ((1)    , (1)    , (1))
                   800
  projection <- return $ projectScene scene

  pixels     <- return $ genPixels projection 500
  let y1 = pixels
  Perf.time y1

  Display.render 500 pixels


