{-
PERFORMANCE MEASUREMENT

Small module to get the runtime of the algorithm so that the graphics display
doesn't change the runtime calculation
-}

module Perf
  ( time
  )
where

import           System.CPUTime
import           Text.Printf
import           Control.Exception
import           Control.Parallel.Strategies
import           Control.Monad
import           Control.DeepSeq
import           System.Environment
import           System.Directory

lim :: Int
lim = 10 ^ 6

myrnf a = a `seq` ()

time :: t -> IO ()
time y = do
  start <- getCPUTime
  replicateM_ lim $ do
    x <- evaluate $ y
    myrnf x `seq` return ()
  end <- getCPUTime
  let diff = (fromIntegral (end - start)) / (10 ^ 12)
  Prelude.putStrLn "Rendering Computation Runtime:"
  printf "Computation time: %0.9f sec\n" (diff :: Double)
  printf "Individual time: %0.9f sec\n"  (diff / fromIntegral lim :: Double)
  return ()
