{-
HIDDEN SURFACE ELIMINATION

This module takes care of checking the z-buffer for the shallowest depth pixel to
be included in the render.  
-}

module HSE
  ( removeHiddenPixels
  )
where

import           Lib
import           Data.Map.Strict                ( Map
                                                , lookup
                                                , insert
                                                , empty
                                                , elems
                                                , fromList
                                                , union
                                                )

removeHiddenPixels :: [Pixel] -> [Pixel] -> [Pixel]
removeHiddenPixels ps borderPixels =
  elems $ Prelude.foldl compareDepth Data.Map.Strict.empty ps


compareDepth :: Map (Int, Int) Pixel -> Pixel -> Map (Int, Int) Pixel
compareDepth hm p@(Pixel { pX = x, pY = y, pDepth = d }) =
  Data.Map.Strict.insert (x, y) minPixel hm
 where
  minPixel = case (Data.Map.Strict.lookup (x, y) hm) of
    Nothing                         -> p
    Just pOld@Pixel { pDepth = d' } -> if d' > d then p else pOld


