{-
DISPLAY CODE

Used to render the actual pixels to the screen using Gloss
-}


module Display
  ( render
  )
where

import           Graphics.Gloss
import           Data.Word                      ( Word8 )
import           Lib                            ( Pixel(Pixel)
                                                , Pixel(pX)
                                                , Pixel(pY)
                                                , Pixel(pRgb)
                                                , Rgb
                                                )
import           Data.Map                       ( Map
                                                , fromList
                                                , findWithDefault
                                                )
import           Data.ByteString                ( ByteString
                                                , pack
                                                )

render :: Int -> [Pixel] -> IO ()
render screenW pixels = display
  (InWindow "Display Window" (600, 600) (60, 60))
  white
  picture
 where
  picture = bitmapOfByteString screenW
                               screenW
                               (BitmapFormat BottomToTop PxRGBA)
                               bitmapData
                               True
  bitmapData = pixels2BitMap screenW screenW pixels

pixels2BitMap :: Int -> Int -> [Pixel] -> ByteString
pixels2BitMap screenW screenH pixels = pack
  (genBitMap 0 (screenW * screenH) filledPixels)
  where filledPixels = fromList $ Prelude.map (pixel2ByteIndex screenW) pixels


genBitMap :: Int -> Int -> Map Int Rgb -> [Word8]
genBitMap n len hm = if n < len
  then r : g : b : 255 : (genBitMap (n + 1) len hm)
  else []
  where (r, g, b) = Data.Map.findWithDefault ((255, 255, 255)) n hm

pixel2ByteIndex :: Int -> Pixel -> (Int, Rgb)
pixel2ByteIndex w (Pixel { pX = x, pY = y, pRgb = rgb' }) = ((y * w) + x, rgb')


