module Main where

import           Perf
import           System.Environment
import           Display
import           Projection                     ( genPixels )
import           Scene                          ( fromPLY
                                                , projectScene
                                                )


data FileArg = Name String | Invalid
getFilename :: [String] -> FileArg
getFilename [fname] = Name fname
getFilename _       = Invalid

main :: IO ()
main = do

  args  <- System.Environment.getArgs
  scene <- case (getFilename args) of
    Name s  -> fromPLY s ((-1000), (-1000), 500) ((1), (1), (1)) 800
    Invalid -> error "Usage: polyrend-exe <filename>"
  projection <- return $ projectScene scene

  pixels     <- return $ genPixels projection 500
  let y1 = pixels
  Perf.time y1

  Display.render 500 pixels
