module Main where

import Data.List (sort, group, sortBy, groupBy, isPrefixOf, isInfixOf, sortOn)
import Data.Text (isSuffixOf)
import Control.Parallel
import Control.Parallel.Strategies
import Data.Char (isAlpha, isSpace, toLower)
import qualified Data.ByteString.Char8 as BC
import qualified Data.Trie as T
import qualified Data.Map as M
import System.Directory
import System.IO

mapReduce :: NFData b1 => (a -> b1) -> ([b1] -> b2) -> [a] -> b2
mapReduce mapper reducer input = pseq mOutput rOutput
  where mOutput = parMap (rpar `dot` rdeepseq) mapper input
        rOutput = reducer mOutput `using` rseq


mappingFunc :: String -> M.Map String Int
mappingFunc document = getWordFreqMap $ (strToList) document


getWordFreqMap :: [String] -> M.Map String Int
getWordFreqMap tokens = M.fromListWith (+) (map (\x -> (x, 1)) tokens)

strToList :: String -> [String]
strToList str = words $ filter (\char -> isAlpha char || isSpace char) $ map toLower str

reducingFunc :: [M.Map String Int] -> [(String, Int)]
reducingFunc maps = M.toList $ foldl (\foldMap (word, count) -> M.insertWith (+) word count foldMap) (M.empty)  listOfMaps
                where listOfMaps = concat (map M.toList maps)

loadList :: FilePath -> IO (M.Map String Int)
loadList fname = do
    filedata <- readFile fname
    contents <- return (read filedata :: [(String, Int)])
    let loadedMap = M.fromList contents
    return loadedMap

saveList :: Show a => a -> FilePath -> IO ()
saveList ls fname= writeFile fname (show ls)

FilePath -> IO ()
buildWordList directory = do
                        files <- listDirectory directory
                        let myFiles = filter (\x -> not (elem x [".", ".."])) (map (\x -> directory ++ x) files)
                        parsedFiles <- mapM readFile myFiles
                        let freqMap = mapReduce mappingFunc reducingFunc parsedFiles
                        putStrLn $ "Found " ++ (show.length) freqMap ++ " words!"
                        saveList freqMap "word_counts.txt"

buildTrie :: M.Map String Int -> T.Trie Int
buildTrie loadedMap = T.fromList (map (\x -> (BC.pack (fst x), snd x::Int)) (M.toList loadedMap))


Ord b1 => T.Trie b1 -> IO b2
userInput trie = do
   putStrLn "enter word"
   pre <- getLine
   putStrLn "Enter number of words you want..."
   k <- getLine
   let topk =  take (read k::Int) (sortBy (\(_,a) (_,b) -> flip compare a b) $ T.toList (T.submap (BC.pack pre) trie))
   putStrLn "Found the following words"
   putStrLn " - Start - "
   mapM_ (\(a,_) -> putStrLn $ BC.unpack a) topk
   putStrLn " - Finish - "
   userInput trie


main :: IO ()
main = do
--    buildWordList "./data/"
    loadedMap <- loadList "data.txt"
    let trie = buildTrie loadedMap
    putStrLn $ "Found " ++ (show $ T.size trie) ++ " words"
    userInput trie
