{-# LANGUAGE BlockArguments #-}

import System.Environment(getArgs)
import System.IO(readFile)
import System.Exit(exitFailure)
import Data.List(sortBy)
import MapReduce (mapReduce)
import Control.Parallel.Strategies
import Control.Parallel (pseq)
import Control.DeepSeq
import Control.Exception
import Data.List
import Data.Ord
import Data.Function (on)
import Puzzle (solve)

shuffler :: Ord a => [(a,b)] -> [(a,[b])]
shuffler = map (\x -> (fst $ head x,  map snd x)) . groupBy ((==) `on` fst) . sortBy (comparing fst)

mapper :: [Int] -> (Int, Int)
mapper l = (solve l, 1)

reducer :: (Int, [Int]) -> (Int, Int)
reducer (t, l)  = (t, (sum l))

inversions :: [Int] -> Int
inversions [] = 0
inversions (x:xs) = (length (filter (<x) xs)) + inversions xs
main = do
          let per = permutations [1,2,3,4,5,6,7,8,0]
          let solvable = take 1000 (filter (\l -> inversions l `mod` 2 == 0) per)
          let res = mapReduce mapper shuffler reducer solvable
          print res

