module Puzzle 
    (
        solve
    ) where

import Data.Array
import qualified Data.Set as S
import Data.Maybe
data Puzzle = Puzzle (Array (Int,Int) Int) deriving (Eq, Ord)
data State = State (S.Set (Int, Puzzle, [Int])) (S.Set Puzzle) 
finalState = Puzzle $ listArray ((0,0),(2,2)) $ [1,2,3,4,5,6,7,8,0]

-- get a number's index on the board
getIndex :: Int -> Puzzle -> (Int, Int)
getIndex n (Puzzle p) = head $ filter (\idx -> p!idx == n) $ indices p

-- get neighbors of zero
getNeighbors :: Puzzle -> [(Int, Int)]
getNeighbors (Puzzle p) = filter (`elem` indices p) [(zx-1,zy),(zx+1,zy),(zx,zy-1),(zx,zy+1)]
                            where (zx, zy) = getIndex 0 (Puzzle p)
-- swap a pos with 0
swap ::  Puzzle -> (Int, Int) -> (Int,Puzzle)
swap (Puzzle p) pos = (p!pos, Puzzle $ p // [((zx,zy), p!pos), (pos, 0)])
                        where (zx, zy) = getIndex 0 (Puzzle p)
-- possible next moves
getMoves :: Puzzle -> [(Int,Puzzle)]
getMoves (Puzzle p) = map (swap (Puzzle p)) $ getNeighbors (Puzzle p) 

-- manhattan heurisitc for current board
manhattanSum :: Puzzle -> Int
manhattanSum p = sum $ map manhattan [0..8] 
                     where manhattan num = abs(fx-x) + abs(fy-y)
                            where (fx,fy) = getIndex num finalState
                                  (x, y) = getIndex num p

transfer :: State -> (Puzzle, [Int], State)
transfer (State queue visited) = (puz, moves, State nextqueue (S.insert puz visited)) where
    ((h, puz, moves), curqueue) = fromJust $ S.minView queue
    nextmoves = S.fromList $ filter (\(_,p) -> p `S.notMember` visited) $ getMoves puz
    nextqueue = curqueue `S.union` (S.map (\(moved,p) -> (manhattanSum p, p, moved:moves)) nextmoves)

search :: Int -> State -> Int
search i curstate
  | p == finalState = length moves
  | otherwise = search (i+1) nextState
      where (p, moves, nextState) = transfer curstate

searchDebug :: Int -> State -> [Int]
searchDebug i curstate
  | p == finalState = moves
  | otherwise = searchDebug (i+1) nextState
      where (p, moves, nextState) = transfer curstate
    
solve :: [Int] -> Int
solve l = search 0 start
            where start = State (S.singleton (manhattanSum p, p, [])) S.empty
                            where p = Puzzle $ listArray ((0,0),(2,2)) l
solveDebug :: [Int] -> [Int]
solveDebug l = searchDebug 0 start
            where start = State (S.singleton (manhattanSum p, p, [])) S.empty
                            where p = Puzzle $ listArray ((0,0),(2,2)) l

