 module MapReduce
    (
      mapReduce
    ) where

import Control.Parallel (pseq)
import Control.Parallel.Strategies

mapReduce :: (NFData a, NFData b, NFData c, NFData d) =>
    (a -> b) -- mapper
    -> ([b] -> [c]) -- shuffle
    -> (c -> d)    -- reducer
    -> [a] -- state
    -> [d] -- result

mapReduce mapFunc shuffleFunc reduceFunc input = mapResult `pseq` reduceResult
  where mapResult = parMap rdeepseq mapFunc input
        shuffleResult = shuffleFunc mapResult
        reduceResult = parMap rdeepseq reduceFunc shuffleResult 
