{-# LANGUAGE BlockArguments #-}

import System.Environment(getArgs)
import System.IO(readFile)
import System.Exit(exitFailure)
import Data.List(sortBy)
import MapReduce (mapReduce)
import Control.Parallel.Strategies
import Control.Parallel (pseq)
import Control.DeepSeq
import Control.Exception
import Data.List
import Data.Ord
import Data.Function (on)


mapper :: String -> (String, Int)
mapper w = (w, 1)

shuffler :: (Eq a) => [(a,b)] -> [(a,[b])]
shuffler = map (\x -> (fst $ head x,  map snd x)) . groupBy ((==) `on` fst)

reducer :: (String, [Int]) -> (String, Int)
reducer (w, l)  = (w, (sum l))

parse :: String -> String
parse w = head (words w)

main :: IO ()
main = do args <- getArgs
          case args of
            [filename] -> do
              text <- readFile filename 
              let linelist = lines text
              let dict = map parse linelist
              let mr = map reducer $ shuffler $ map mapper dict
              let result = sortBy (\(_ , cnt) (_ , cnt') -> compare cnt' cnt) mr
              print result

