module Mandelbrot where

import Control.Monad.State

type Point = (Float,Float)

grid :: [[ Point ]]
grid = [[ (x/100 ,y/100) 
    | x <- [-200..100]] 
    | y <- [-100..100]]

mandelbrot :: Point -> State (Int,Point) Char
mandelbrot z = do 
    (c,p) <- get
    if c > 2000 || escaped p
    then return $ encode c 
    else do
        modify $ \(i,p') -> (i+1, iterPoint z p')
        mandelbrot z
  where
    escaped (a,b) = a*a + b*b > 4.0
    iterPoint (a_z,b_z) (a,b) = (a*a - b*b + a_z,2.0*a*b + b_z)
    encode count
        | count > 2000  = ' '
        | count > 50    = 'A'
        | count > 10    = 'B'
        | count > 1     = 'C'
        | otherwise     = 'D'
