import System.IO(readFile)
import System.Exit(die)
import System.Environment(getArgs, getProgName)
import Data.Array
import Data.Maybe

data Item = Item { name :: String, weight :: Int, value :: Int, bound :: Int} deriving (Eq, Show)
type SumValue = Int

main :: IO ()
main = do args <- getArgs
          case args of 
            [filename, weightlimit] -> do 
              contents <- readFile filename
              print (knapsack (processFile contents) (read weightlimit::Int)) 
              return () 
            _ -> do 
              pn <- getProgName
              die $ "Usage: " ++ pn ++ " <filename> <weight limit number>"

processFile :: String -> [Item] 
processFile s = map secondProcess $ lines s where
  secondProcess ch = Item (read (w !! 0)) (read (w !! 1)::Int) (read (w !! 2)::Int) (read (w !! 3)::Int) where 
    w = words ch

knapsack :: [Item] -> Int -> (Int, [(String, Int)])
knapsack items ttlwght = (solve items) ! ttlwght
  where
    solve = foldr myroll basearray
    infl = repeat (0, [])
    basearray = listArray (0, ttlwght) infl
    myroll item s = listArray (0,ttlwght) solu
      where
        solu = map getbest [0..]
        getbest w = maximum $ hd:tl
          where
            hd = s!w
            iname = name item
            iv = value item
            iw = weight item
            ib = bound item
            tl = [combine (iv * x, (iname, x)) (s!(w-iw*x)) | x <- [1..ib], iw*x < w]
            combine (a,b) (c,d) = (a+c,b:d)
