## How To Generate Random Data Set

Edit genitem.py with appropriate parameters, and run the python script.

## How To compile

`stack ghc -- -O2 -threaded -rtsopts -eventlog <filename>.hs`

## How To Run Each Solution

#### dp.hs

Sequential dynamic programming method of solving knapsack: 

`stack ghc -- -O2 -rtsopts -eventlog  dp.hs` 
`./dp randomItems.txt 300 +RTS -s`

#### dp-par1.hs

With parMap and runEval:

`stack ghc -- -O2 -Wall -threaded -rtsopts -eventlog dp-par1.hs`
`./dp-par1 randomItems.txt 10 +RTS -N2 -s -ls`

#### dp-par2.hs

With parList:

`stack ghc -- -O2 -Wall -threaded -rtsopts -eventlog dp-par2.hs`
`./dp-par2 randomItems.txt 10 +RTS -N2 -s -ls`

#### dp-par3.hs

With parBuffer:

`stack ghc -- -O2 -Wall -threaded -rtsopts -eventlog dp-par3.hs`
`./dp-par3 randomItems.txt 10 +RTS -N2 -s -ls`

#### dp-par4.hs

With parListChunk:

`stack ghc -- -O2 -Wall -threaded -rtsopts -eventlog dp-par4.hs`
`./dp-par4 randomItems.txt 10 +RTS -N2 -s -ls`
