import Control.Parallel.Strategies
  ( Strategy
  , evalTraversable
  , parTraversable
  , rseq
  , using
  )
import Data.Sequence as DS
  ( Seq
  , ViewR((:>), EmptyR)
  , (!?)
  , (><)
  , chunksOf
  , iterateN
  , replicate
  , viewr
  , zip3
  )
import System.Environment (getArgs)
import System.Exit (die)
import System.IO.Error
  ( catchIOError
  , ioeGetFileName
  , isDoesNotExistError
  , isPermissionError
  , isUserError
  )

{-
    Read in data, call knapsack function, print result.
-}
main :: IO ()
main =
  do [filename, chunks] <- getArgs
     content <- readFile filename
     let n = read chunks :: Int
         [[c], wts, vals] = map toInt $ map words $ lines content
         (val, sol) = knapsack n c $ Prelude.zip3 [1,2 ..] wts vals
     putStrLn $
       "Solution: " ++ (show sol) ++ "\n" ++ "Total Value: " ++ (show val)
     `catchIOError` \e -> die $ handler e
  where
    toInt = map (\x -> read x :: Int)
    handler e =
      case ioeGetFileName e of
        Just fn
          | isDoesNotExistError e -> fn ++ ": File does not exist."
          | isPermissionError e -> fn ++ ": Permission denied."
        _
          | isUserError e -> "Usage: knapsack <filename> <# parallel chunks>"
          | otherwise -> show e

{-
    Wrapper to generate initial table and call dynamic programming algorithm.
-}
knapsack :: Int -> Int -> [(Int, Int, Int)] -> (Int, [Int])
knapsack n c items =
  kdp (c `div` n) items $
  DS.zip3
    (DS.iterateN (c + 1) ((+) 1) 0)
    (DS.replicate (c + 1) 0)
    (DS.replicate (c + 1) [])

{-
    Runner for knapsack dp algorithm.
-}
kdp :: Int -> [(Int, Int, Int)] -> Seq (Int, Int, [Int]) -> (Int, [Int])
kdp n (item:items) tbl =
  kdp n items ((fmap (step tbl item) tbl) `using` (parSequenceChunk n rseq))
kdp _ _ tbl =
  case DS.viewr tbl of
    EmptyR -> (0, [])
    _ :> (_, val, sol) -> (val, sol)

{-
    Computes value in next row for specific column.
-}
step ::
     Seq (Int, Int, [Int])
  -> (Int, Int, Int)
  -> (Int, Int, [Int])
  -> (Int, Int, [Int])
step tbl (i, w, v) (j, val, sol)
  | w > j || val > nval = (j, val, sol)
  | otherwise = (j, nval, osol ++ [i])
  where
    Just (_, oval, osol) = tbl !? (j - w)
    nval = oval + v

{-
    Divide sequence into chunks, then apply evalTraversable in parallel.
    Modified version of Control.Parallel.Strategies.parListChunk.
-}
parSequenceChunk :: Int -> Strategy a -> Strategy (Seq a)
parSequenceChunk n strat xs
  | n <= 1 = parTraversable strat xs
  | otherwise =
    fmap (foldr1 (><)) (parTraversable (evalTraversable strat) (chunksOf n xs))
