module Main where

import           AI
import           Board
import           Data.Char

gameLoop :: Board -> Color -> [Board] -> IO ()
gameLoop board color list
  | null curPoint = putStrLn "Tie"
  | checkWin (head curPoint) curBoard == Empty = do
    putStrLn (show curBoard ++ "\n")
    gameLoop curBoard (oppositeColor color) (list ++ [curBoard])
  | otherwise = do
    putStrLn (show curBoard ++ "\n")
    putStrLn (show color ++ "wins")
  where
    curPoint = getCurPoint board curBoard
    curBoard = moveAI board color

main :: IO ()
main = gameLoop initBoard Black []
