-- ghc -threaded -eventlog --make CF-singlethread.hs -o CF-singlethread
-- ./CF-singlethread ratings1m.dat +RTS -N1 -ls -RTS

import System.Environment(getArgs)
import qualified Data.ByteString.Char8 as BS
import Data.Char(digitToInt)

userNum :: Int
userNum = 6040

movieNum :: Int
movieNum = 3952

printByLine :: (Show a) => [a] -> IO ()
printByLine [] = return ()
printByLine (i:is) = do 
  putStrLn $ show i
  printByLine is

splitLines :: [Char] -> [[Char]]
splitLines [] = []
splitLines (s:xs)
  | s == '\n' = splitLines xs
  | otherwise = (takeWhile (/='\n') (s:xs)) : (splitLines $ dropWhile (/='\n') (s:xs))

similarity :: Integral a => [a] -> [a] -> Double
similarity u1f u2f = (dot / sqr1 / sqr2) :: Double where
  f1 = \acc x -> acc + x
  f2 = \acc x -> acc + x * x
  dot = fromIntegral $ foldl f1 0 (zipWith (*) u1f u2f)
  sqr1 = sqrt $ fromIntegral $ foldl f2 0 u1f
  sqr2 = sqrt $ fromIntegral $ foldl f2 0 u2f

calcSimMat :: [[Char]] -> [[Char]] -> [Double]
calcSimMat xm ym = [similarity (map digitToInt x) (map digitToInt y) | x <- xm, y <- ym]

main :: IO ()
main = do
  [filename] <- getArgs
  contents <- BS.readFile filename
  let 
    umMat = splitLines $
            BS.unpack contents
    simMat = calcSimMat umMat umMat
  
  print $ length simMat
  return ()
