-- ghc -threaded -eventlog -rtsopts --make CF-multithread_dyn.hs -o CF-multithread_dyn
-- ./CF-multithread_dyn ratings1m.dat +RTS -N1 -g1 -ls -RTS

import System.Environment(getArgs)
import qualified Data.ByteString.Char8 as BS
import Data.Char(digitToInt)
import Control.Exception
import System.Environment
import Control.Parallel.Strategies hiding (parMap)

userNum :: Int
userNum = 6040

movieNum :: Int
movieNum = 3952

printByLine :: (Show a) => [a] -> IO ()
printByLine [] = return ()
printByLine (i:is) = do 
  putStrLn $ show i
  printByLine is

splitLines :: [Char] -> [[Char]]
splitLines [] = []
splitLines (s:xs)
  | s == '\n' = splitLines xs
  | otherwise = (takeWhile (/='\n') (s:xs)) : (splitLines $ dropWhile (/='\n') (s:xs))

similarity :: Integral a => ([a], [a]) -> Double
similarity inp = (dot / sqr1 / sqr2) :: Double where
  u1f = fst inp
  u2f = snd inp
  f1 = \acc x -> acc + x
  f2 = \acc x -> acc + x * x
  dot = fromIntegral $ foldl f1 0 (zipWith (*) u1f u2f)
  sqr1 = sqrt $ fromIntegral $ foldl f2 0 u1f
  sqr2 = sqrt $ fromIntegral $ foldl f2 0 u2f

parMap f [] = return []
parMap f (a:as) = do 
  b <- rpar (f a)
  bs <- parMap f as
  return (b:bs)

main :: IO ()
main = do
  [filename] <- getArgs
  contents <- BS.readFile filename
  let 
    umMat = splitLines $
            BS.unpack contents
    -- (aMat, xMat) = splitAt 100 umMat
    -- (bMat, zMat) = splitAt 100 xMat
    (aMat, bMat) = splitAt 3020 umMat

  r <- evaluate $ runEval $ do
    rr <- parMap similarity [ (map digitToInt x, map digitToInt y) | x <- aMat, y <- bMat]

    return ((length rr))
  
  print r