-- ghc -threaded -eventlog -rtsopts --make CF-multithread.hs -o CF-multithread
-- ./CF-multithread ratings1m.dat +RTS -N1 -g1 -ls -RTS

import System.Environment(getArgs)
import qualified Data.ByteString.Char8 as BS
import Data.Char(digitToInt)
import Control.DeepSeq(deepseq, NFData)
import Control.Exception(evaluate)
import Control.Parallel.Strategies(runEval, rpar, rseq)

userNum :: Int
userNum = 6040

movieNum :: Int
movieNum = 3952

printByLine :: (Show a) => [a] -> IO ()
printByLine [] = return ()
printByLine (i:is) = do 
  putStrLn $ show i
  printByLine is

splitLines :: [Char] -> [[Char]]
splitLines [] = []
splitLines (s:xs)
  | s == '\n' = splitLines xs
  | otherwise = (takeWhile (/='\n') (s:xs)) : (splitLines $ dropWhile (/='\n') (s:xs))

similarity :: Integral a => [a] -> [a] -> Double
similarity u1f u2f = (dot / sqr1 / sqr2) :: Double where
  f1 = \acc x -> acc + x
  f2 = \acc x -> acc + x * x
  dot = fromIntegral $ foldl f1 0 (zipWith (*) u1f u2f)
  sqr1 = sqrt $ fromIntegral $ foldl f2 0 u1f
  sqr2 = sqrt $ fromIntegral $ foldl f2 0 u2f

calcSimMat :: [[Char]] -> [[Char]] -> [Double]
calcSimMat xm ym = [similarity (map digitToInt x) (map digitToInt y) | x <- xm, y <- ym]

deep :: NFData a => a -> a
deep a = deepseq a a

main :: IO ()
main = do
  [filename] <- getArgs
  contents <- BS.readFile filename
  let 
    umMat = splitLines $
            BS.unpack contents
    -- (aMat, xMat) = splitAt 100 umMat
    -- (bMat, zMat) = splitAt 100 xMat
    (aMat, bMat) = splitAt 3020 umMat

  r <- evaluate $ runEval $ do
    a <- rpar (calcSimMat aMat aMat)
    b <- rpar (calcSimMat aMat bMat)
    c <- rpar (calcSimMat bMat aMat)
    d <- rpar (calcSimMat bMat bMat)
    rseq a
    rseq b
    rseq c
    rseq d

    return ((length a) + (length b) + (length c) + (length d))
  
  print r