{-# LANGUAGE NoImplicitPrelude #-}

module Types where

import           RIO
import           RIO.Process

import           CellularFluid.Grid.Types

-- | Command line arguments
data Options =
  Options
    { optionsVerbose  :: !Bool
    , optionsInput    :: !FilePath
    , optionsOutput   :: !FilePath
    , optionsTimeStep :: !Int
    }

data App =
  App
    { appLogFunc        :: !LogFunc
    , appProcessContext :: !ProcessContext
    , appOptions        :: !Options
    }

data SimApp =
  SimApp
    { simHandle  :: !Handle
    , simCfg     :: !SimulationCFG
    , simGrid    :: !Grid
    , simLogFunc :: !LogFunc
    , simSteps   :: !Int
    }

instance HasLogFunc App where
  logFuncL = lens appLogFunc (\x y -> x {appLogFunc = y})

instance HasLogFunc SimApp where
  logFuncL = lens simLogFunc (\x y -> x {simLogFunc = y})

instance HasProcessContext App where
  processContextL = lens appProcessContext (\x y -> x {appProcessContext = y})

class HasOptions env where
  optionsL :: Lens' env Options

instance HasOptions App where
  optionsL = lens appOptions (\x y -> x {appOptions = y})

class HasSimInfo env where
  simCfgL :: Lens' env SimulationCFG
  outHandleL :: Lens' env Handle

instance HasSimInfo SimApp where
  simCfgL = lens simCfg (\x y -> x {simCfg = y})
  outHandleL = lens simHandle (\x y -> x {simHandle = y})
